'use strict'

modules['orbitCam'] = {
    config: [
        ['distance', 'float', 70],
        ['roll', 'angle', 0],
        ['height', 'float', 0],
        ['rotation', 'angle', 0],
        ['fov', 'angle', 90],
        ['lookAt', 'float3', [0, 0, 0]],
        ['stepSize', 'float', 0],
    ],

    render: async (time, self, config) => {
        const {
            distance,
            height,
            fov,
            lookAt,
            stepSize
        } = { ...config }
        let {
            roll,
            rotation
        } = { ...config }

        if (stepSize > 0) {
            roll = Math.floor(roll * stepSize) / stepSize
            rotation = Math.floor(rotation * stepSize) / stepSize
        }

        const camera = m4.lookAt([lookAt[0] + Math.sin(rotation) * distance, lookAt[1] - height, lookAt[2] + Math.cos(rotation) * distance], lookAt, [0, 1, 0])
        const rollMat = m4.zRotation(roll)
        const view = m4.multiply(rollMat, m4.inverse(camera))
        const perspective = m4.perspective(fov, 640/480, 1, 500)
        camViewPersp = m4.multiply(perspective, view)
    }
}
