'use strict'

modules['present'] = {
    config: [
        ['colourField', 'string', 'default'],
        ['colourField2', 'string', null],
        ['mode', 'string', 'set'],
    ],

    render: async (time, self, config) => {
        const {
            colourField,
            colourField2,
            mode,
        } = {...config}

        const colourFieldTexture1 = getColourTexture(colourField).data
        const colourFieldTexture2 = colourField2 ? getColourTexture(colourField2).data : colourFieldTexture1
        switch (mode) {
            case 'set': presentSlow(getOutputBufferId(), colourFieldTexture1, colourFieldTexture2); break
            case 'mask': presentSlowMask(getOutputBufferId(), colourFieldTexture1, colourFieldTexture2); break
            case 'add': presentSlowAdd(getOutputBufferId(), colourFieldTexture1, colourFieldTexture2); break
            case 'alpha': presentSlowAlpha(getOutputBufferId(), colourFieldTexture1, colourFieldTexture2); break
        }
    }
}
