'use strict'

modules['remap'] = {
    config: [
        ['merge', 'float', 1],
    ],

    // init: () => {
    //     const MAP_SIZE = 640 * 480
    //     const pixelMap = Array(MAP_SIZE).fill(0)

    //     /*
    //     const rng = new Math.seedrandom('remap')
    //     let offsetX
    //     for (let x = 0; x < 640; ++x) {
    //         if ((x % 40) === 0) {
    //             offsetX = Math.floor(rng()*41-20)
    //         }
    //         const mapX = Math.max(Math.min(x + offsetX, 640-1), 0)
    //         for (let y = 0; y < 480; ++y) {
    //             const value = mapX + y*640
    //             pixelMap[x + y*640] = value
    //         }
    //     }
    //     */

    //     const addRect = (sx, sy, w, h, dx, dy) => {
    //         for (let y = 0; y < h; ++y) {
    //             for (let x = 0; x < w; ++x){
    //                 const src = (sx + x) + ((sy + y) * 640)
    //                 const dst = (dx + x) + ((dy + y) * 640)
    //                 pixelMap[dst] = src
    //             }
    //         }
    //     }
    //     addRect(0, 0, 640, 480, 640, 480)

    //     /*
    //     for (let y = 0; y < 480; ++y) {
    //         for (let x = 0; x < 640; ++x) {
    //             const normalX = ((x / (640-1)) - 0.5) * 2
    //             const mapX = x - Math.floor(Math.pow(Math.abs(normalX), .33) * Math.sign(normalX) * 40)
    //             const normalY = ((y / (648040-1)) - 0.5) * 2
    //             const mapY = y - Math.floor(Math.pow(Math.abs(normalY), .33) * Math.sign(normalY) * 40)
    //              const value = mapX + mapY*640
    //             pixelMap[x + y*640] = value
    //         }
    //     }
    //     */

    //     return {
    //         pixelMap
    //     }
    // },

    render: async (time, self, config) => {
        const {
            merge
        } = { ...config }

        const srcBuffer = greyscaleBuffers[getOutputBufferId()]
        const dstBufferId = lockBuffer()
        const dstBuffer = greyscaleBuffers[dstBufferId]

        const addRect = (sx, sy, w, h, dx, dy, rx, ry) => {
            for (let y = 0; y < h; ++y) {
                for (let x = 0; x < w; ++x){
                    const src = (sx + x)*rx + ((sy + y)*ry * 640)
                    const dst = (dx + x) + ((dy + y) * 640)
                    dstBuffer[dst] = lerp(dstBuffer[dst], 1 - srcBuffer[src], merge)
                }
            }
        }
        for (let i = 0; i < 640*480; ++i) {
            dstBuffer[i] = srcBuffer[i]
        }
        // addRect(0, 0, 640, 480, 1, 1)
        // addRect(0, 0, 640/4, 480/4, 640-160-50, 40, 4, 4)
        // addRect(0, 0, 640/4, 480/4, 640-160-50, 180, 4, 4)
        addRect(0, 0, 640/4, 480/4, 640-160-50, 320, 4, 4)
        // addRect(160, 70, 320, 320, 40, 40)
        // addRect(40, 40, 80, 400, 400, 40)
        // addRect(120, 40, 80, 400, 520, 40)

        /*
        for (let i = 0; i < 640 * 480; ++i) {
            dstBuffer[i] = srcBuffer[self.pixelMap[i]]
        }
        */

        unlockBuffer(getOutputBufferId())
        setOutputBufferId(dstBufferId)
    }
}
