'use strict'

modules['triangleField'] = {
    config: [
        ['brightness', 'float', 1],
        ['border', 'float', .5],
        ['gridSize', 'int', 10],
        ['alternatePattern', 'boolean', false],
        ['drawMode', 'string', 'tris'],
        ['time1', 'float', 0],
        ['scale1', 'float', 0.05],
        ['strength1', 'float', 4],
        ['time2', 'float', 0],
        ['scale2', 'float', 0.05],
        ['strength2', 'float', 4],
        ['position', 'float2', [0, 0]],
    ],

    render: async (time, self, config) => {
        const {
            brightness,
            border,
            gridSize,
            alternatePattern,
            drawMode,
            time1,
            scale1,
            strength1,
            time2,
            scale2,
            strength2,
            position,
        } = { ...config }

        let heightGrid = []
        for (let y = -gridSize; y <= gridSize; ++y) {
            for (let x = -gridSize; x <= gridSize; ++x) {
                const value = 
                    noise.simplex3(position[0] + x*scale1, position[1] + y*scale1, time1) * strength1 + 
                    noise.simplex3(position[0] + x*scale2, position[1] + y*scale2, time2) * strength2
                heightGrid.push(value)
            }
        }

        const verts = []
        const tris = []
        const lines = []
        let index = 0
        for (let y = -gridSize; y < gridSize; ++y) {
            for (let x = -gridSize; x < gridSize; ++x) {
                const heightGridIndex = (x+gridSize) + ((y+gridSize)*(gridSize*2+1))

                let gridVerts

                if (alternatePattern && (x^y)&1) {
                    gridVerts = [
                        [x, heightGrid[heightGridIndex], y],
                        [x+1, heightGrid[heightGridIndex+1], y],
                        [x, heightGrid[heightGridIndex+gridSize*2+1], y+1],
                        [x+1, heightGrid[heightGridIndex+1+gridSize*2+1], y+1],
                    ]
                } else {
                    gridVerts = [
                        [x, heightGrid[heightGridIndex+gridSize*2+1], y+1],
                        [x, heightGrid[heightGridIndex], y],
                        [x+1, heightGrid[heightGridIndex+1+gridSize*2+1], y+1],
                        [x+1, heightGrid[heightGridIndex+1], y],
                    ]
                }

                const middle1 = [
                    (gridVerts[0][0] + gridVerts[1][0] + gridVerts[2][0]) / 3,
                    (gridVerts[0][1] + gridVerts[1][1] + gridVerts[2][1]) / 3,
                    (gridVerts[0][2] + gridVerts[1][2] + gridVerts[2][2]) / 3,
                ]
                const middle2 = [
                    (gridVerts[1][0] + gridVerts[2][0] + gridVerts[3][0]) / 3,
                    (gridVerts[1][1] + gridVerts[2][1] + gridVerts[3][1]) / 3,
                    (gridVerts[1][2] + gridVerts[2][2] + gridVerts[3][2]) / 3,
                ]
                
                verts.push(
                    m4.addVectors(gridVerts[0], m4.multiplyVector(m4.normalize(m4.subtractVectors(middle1, gridVerts[0])), border)),
                    m4.addVectors(gridVerts[1], m4.multiplyVector(m4.normalize(m4.subtractVectors(middle1, gridVerts[1])), border*2)),
                    m4.addVectors(gridVerts[2], m4.multiplyVector(m4.normalize(m4.subtractVectors(middle1, gridVerts[2])), border*2)),
                    m4.addVectors(gridVerts[1], m4.multiplyVector(m4.normalize(m4.subtractVectors(middle2, gridVerts[1])), border*2)),
                    m4.addVectors(gridVerts[3], m4.multiplyVector(m4.normalize(m4.subtractVectors(middle2, gridVerts[3])), border)),
                    m4.addVectors(gridVerts[2], m4.multiplyVector(m4.normalize(m4.subtractVectors(middle2, gridVerts[2])), border*2)),
                )

                if (drawMode === 'lines') {
                    lines.push([index+0, index+1])
                    lines.push([index+1, index+2])
                    lines.push([index+2, index+0])
                    lines.push([index+3, index+4])
                    lines.push([index+4, index+5])
                    lines.push([index+5, index+3])
                    index += 6
                } else if (drawMode === 'tris') {
                    tris.push([index++, index++, index++])
                    tris.push([index++, index++, index++])
                }
            }
        }

        renderer.drawLists(greyscaleBuffers[getOutputBufferId()], m4.identity(), verts, lines, brightness, tris, brightness, [], brightness)
    }
}
