// modified from https://github.com/anissen/ld34/blob/master/assets/shaders/glitch.glsl

#version 130

precision mediump float;

uniform sampler2D currentTexture;
uniform float frequency;
uniform float glitchAmount;
uniform vec2 u_resolution;
uniform float time;

void main() {
    
        vec4 val = texture2D(currentTexture, gl_TexCoord[0].xy);

	// colour offset glitch
	val.r = texture2D(currentTexture, gl_TexCoord[0].xy + vec2(glitchAmount / u_resolution.x, 0.0)).r;
	val.g = texture2D(currentTexture, gl_TexCoord[0].xy).g;
	val.b = texture2D(currentTexture, gl_TexCoord[0].xy + vec2(-glitchAmount / u_resolution.x, 0.0)).b;

	// the scanline
	val.rgb *= 0.8 + 0.2 * sin(frequency * gl_FragCoord.y + time);

	gl_FragColor = val;
}
