#version 450
layout(set = 0, binding = 0) uniform _Time { float Time; };
layout(set = 0, binding = 1) uniform _Offset { vec2 Offset; };
layout(set = 0, binding = 2) uniform _Zoom { float Zoom; };
layout(location = 0) in vec2 fsin_Position;
layout(location = 0) out vec4 fsout_Color;
float beat = 0.7142857;
float beats = (Time / beat);
vec2 pR(vec2 p, float a)
{
p = ((p * cos(a)) + (vec2(p.y, (-p.x)) * sin(a)));
return p;

}

float rand1d(float n)
{
return fract((sin(n) * 43758.55));

}

float noise(vec2 uv, float intensity)
{
return min(1.0, ((1.0 / (rand1d(((uv.x * 20.0) + 1.0)) + rand1d((uv.y * 40.0)))) * intensity));

}

float spikeFunc(float x)
{
return max(min(min(fract(x / -2.) * 2. -1., sin((x + 1.) / 0.31831 ) + 1.), sin((x - 1.278) / 0.31831) + 0.645), 0.);

}

float superclamp(float val, float start, float end)
{
float dur = (end - start);
float halfdur = (dur / 2.0);
float prog = (clamp(val, start, end) - start);
return ((halfdur - abs((prog - halfdur))) / halfdur);

}

float sphereFn(vec3 p, float radius)
{
return length(p) - radius;

}


vec3 gp;

void pRx(inout vec2 p, float a)
{
	p = cos(a)*p + sin(a)*vec2(p.y, -p.x);
}

float elipse(vec3 p, vec3 r )
{
    float k0 = length(p/r);
    float k1 = length(p/(r*r));
    return k0*(k0-1.0)/k1;
}

float box(vec3 p, vec3 b)
{
	return length(max(abs(p) - b, 0.0));
}

float vmax(vec3 v) {
	return max(max(v.x, v.y), v.z);
}

float box2(vec3 p, vec3 b) {
	return vmax(abs(p) - b);
}

float box3( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return length(max(d,0.0));
         + min(max(d.x,max(d.y,d.z)),0.0); // remove this line for an only partially signed sdf 
}

float gSPACE(vec3 p)
{
    gp.x -= 0.10;
    
    return 1.0 / 0.0;
}

float gA(vec3 p)
{
    gp.x -= 0.30;
    float d = 1.0 / 0.0;
    d = min( d, box( p, vec3( 0.12, 0.18, 0.07 )) );

    p.y -= 0.06;
    d = max( d, -box2( p, vec3( 0.02, 0.06, 0.1 )) );

    p.y += 0.18;
    d = max( d, -box2( p, vec3( 0.02, 0.08, 0.1 )) );

    p.y -= 0.30;
    p.x -= 0.12;
    vec3 t = p;
    pRx( t.xy, 3.14592/4.0 );
    d = max( d, -box2(t,vec3( 0.05, 0.05, 0.1)) );

    p.x += 0.24;
    t = p;
    pRx( t.xy, 3.14592/4.0 );
    d = max( d, -box2(t,vec3( 0.05, 0.05, 0.1)) );

    return d;
}

float gB(vec3 p)
{
    gp.x -= 0.30;
    float d = 1.0 / 0.0;
    d = min( d, box( p, vec3( 0.12, 0.18, 0.07 )) );

    p.y -= 0.06;
    d = max( d, -box2( p, vec3( 0.02, 0.06, 0.1 )) );

    p.y += 0.15;
    d = max( d, -box2( p, vec3( 0.02, 0.05, 0.1 )) );

    p.y -= 0.30;
    p.x -= 0.12;
    vec3 t = p;
    pRx( t.xy, 3.14592/4.0 );
    d = max( d, -box2(t,vec3( 0.05, 0.05, 0.1)) );

    p.y += 0.42;
    t = p;
    pRx( t.xy, 3.14592/4.0 );
    d = max( d, -box2(t,vec3( 0.05, 0.05, 0.1)) );

    p.y -= 0.19;
    p.x -= 0.04;
    t = p;
    pRx( t.xy, 3.14592/4.0 );
    d = max( d, -box2(t,vec3( 0.05, 0.05, 0.1)) );

    return d;
}

float gC(vec3 p)
{
    gp.x -= 0.30;
    float d = 1.0 / 0.0;
    d = min( d, box( p, vec3( 0.12, 0.18, 0.07 )) );

    p.y -= 0.00;
    p.x -= 0.06;
    d = max( d, -box2( p, vec3( 0.08, 0.14, 0.1 )) );

    p.y += 0.22;
    //d = max( d, -box2( p, vec3( 0.02, 0.08, 0.1 )) );

    return d;
}

float gD(vec3 p)
{
    gp.x -= 0.30;
    float d = 1.0 / 0.0;
    d = min( d, box( p, vec3( 0.12, 0.18, 0.07 )) );

    d = max( d, -box2( p, vec3( 0.02, 0.14, 0.1 )) );

    p.y -= 0.20;
    p.x -= 0.12;
    vec3 t = p;
    pRx( t.xy, 3.14592/4.0 );
    d = max( d, -box2(t,vec3( 0.05, 0.05, 0.1)) );

    p.y += 0.40;
    t = p;
    pRx( t.xy, 3.14592/4.0 );
    d = max( d, -box2(t,vec3( 0.05, 0.05, 0.1)) );

    return d;
}

float gH(vec3 p)
{
    gp.x -= 0.30;
    float d = 1.0 / 0.0;
    d = min( d, box( p, vec3( 0.12, 0.18, 0.07 )) );

    p.y -= 0.10;
    d = max( d, -box2( p, vec3( 0.02, 0.10, 0.1 )) );

    p.y += 0.22;
    d = max( d, -box2( p, vec3( 0.02, 0.08, 0.1 )) );

    return d;
}

float gL(vec3 p)
{
    gp.x -= 0.30;
    float d = 1.0 / 0.0;
    d = min( d, box( p, vec3( 0.12, 0.18, 0.07 )) );

    p.y -= 0.10;
    p.x -= 0.06;
    d = max( d, -box2( p, vec3( 0.08, 0.24, 0.1 )) );

    p.y += 0.22;
    //d = max( d, -box2( p, vec3( 0.02, 0.08, 0.1 )) );

    return d;
}

float gU(vec3 p)
{
    gp.x -= 0.30;
    float d = 1.0 / 0.0;
    d = min( d, box( p, vec3( 0.12, 0.18, 0.07 )) );

    p.y -= 0.10;
    d = max( d, -box2( p, vec3( 0.02, 0.24, 0.1 )) );

    return d;
}

float smin( float a, float b, float k )
{
    float res = exp2( -k*a ) + exp2( -k*b );
    return -log2( res )/k;
}

vec3 crap
;
vec4 scene(vec3 p)
{
float d = (round((((floor((pR((p.xy * 1.5), (floor(((round(((pR(vec2((p.z * 1.0), cos(max(pR(vec2((p.z * 1.0), pR(vec2((p.z * 1.0), (floor(((round((max((-(tan((floor((((round((pR((p.zx * 2.0), pR((p.xy * 1.5), (pR(vec2((p.y * 1.0), (floor((pR((p.zy * 1.5), pR(vec2((p.x * 1.0), sin(pR((p.yz * 2.0), (tan(sin(pR(vec2((p.y * 1.0), pR(vec2((p.x * 1.0), pR((p.zx * 2.0), pR(vec2((p.x * 1.0), sin(length(vec2(pR(vec2((p.x * 1.0), max(pR((p.zy * 1.5), pR((p.xy * 1.5), (floor((pR(vec2((p.x * 1.0), (-max(pR((p.yz * 2.0), ((floor((pR(vec2((p.z * 1.0), (pR(vec2((p.x * 1.0), pR(vec2((p.y * 1.0), (((floor((pR((p.zy * 1.5), (floor(((length(vec2(pR(vec2((p.z * 1.0), (round(((-min(1.0, (max(1.0, (beats / 12.0)) - 1.0))) * 7.0)) / 7.0)), (p.y / 1.0)).y, (max(0.0, (0.2 - fract(((beats * 2.0) + 0.04)))) * step(16.0, beats)))) + min(1.0, (max(1.0, (beats / 36.0)) - 1.0))) * 7.0)) / 7.0)).x * 7.0)) / 7.0) - min(1.0, (max(1.0, (beats / 36.0)) - 1.0))) - (max(0.0, (0.2 - fract(((beats * 2.0) + 0.04)))) * step(16.0, beats)))), (max(0.0, (0.2 - fract(((beats * 2.0) + 0.04)))) * step(16.0, beats))).y), max(1.0, (beats / 36.0))).x / (1.3 / min(1.0, (max(1.0, (beats / 36.0)) - 1.0))))), min(1.0, (max(1.0, (beats / 12.0)) - 1.0))).y * 7.0)) / 7.0) + max(1.0, (beats / 36.0)))).y, min(1.0, (max(1.0, (beats / 12.0)) - 1.0))))), Time).x * 7.0)) / 7.0)).y).x, max(1.0, (beats / 36.0)))), max(1.0, (beats / 12.0))).x, max(1.0, (beats / 12.0)))))), (max(0.0, (0.2 - fract(((beats * 2.0) + 0.04)))) * step(16.0, beats))).x).x), ((floor((((max(16.0, beats) - 16.0) * 2.0) + 0.04)) * step(16.0, beats)) * 0.1)).x), (length(p) * 10.0)).y)) / 2.0)).y)), max(1.0, (beats / 12.0))).x).x * 7.0)) / 7.0)), min(1.0, (max(1.0, (beats / 12.0)) - 1.0))).y + 3.1416)).y).x * 7.0)) / 7.0) - (length(p) * 10.0)) * 7.0)) / 7.0)) / 2.0)), min(1.0, (max(1.0, (beats / 12.0)) - 1.0))) * 7.0)) / 7.0) * 7.0)) / 7.0)), max(1.0, (beats / 36.0))).y), (p.x / 1.0)).y, Time))), ((floor((((max(16.0, beats) - 16.0) * 2.0) + 0.04)) * step(16.0, beats)) * 0.1)).y / (1.3 / min(1.0, (max(1.0, (beats / 12.0)) - 1.0)))) * 7.0)) / 7.0) * 7.0)) / 7.0)).y * 7.0)) / 7.0) + max(1.0, (beats / 36.0))) * 7.0)) / 7.0);
vec3 r = (vec3(pR(vec2((p.x * 1.0), (round((((floor((pR(vec2((p.y * 1.0), (pR(vec2((p.z * 1.0), (pR(vec2((p.x * 1.0), (pR(vec2((p.x * 1.0), max(1.0, (beats / 12.0))), Time).x - (length(p) * 10.0))), max(1.0, (beats / 36.0))).x + max(1.0, (beats / 12.0)))), (max(0.0, (0.2 - fract(((beats * 2.0) + 0.04)))) * step(16.0, beats))).y / (1.3 / Time))), Time).y * 7.0)) / 7.0) / (1.3 / max(1.0, (beats / 12.0)))) * 7.0)) / 7.0)), max(1.0, (beats / 12.0))).x) * vec3(1.0, 0.0, 0.0));
vec3 g = (vec3(length(vec2((pR((p.zx * 2.0), ((round((pR((p.xy * 1.5), min(1.0, (max(1.0, (beats / 36.0)) - 1.0))).y * 7.0)) / 7.0) + (max(0.0, (0.2 - fract(((beats * 2.0) + 0.04)))) * step(16.0, beats)))).x + max(1.0, (beats / 36.0))), 3.1416))) * vec3(0.0, 1.0, 0.0));
vec3 b = (vec3(pR(vec2((p.x * 1.0), pR((p.zy * 1.5), (floor((length(vec2(pR(vec2((p.z * 1.0), (floor((pR(vec2((p.x * 1.0), (round((pR(vec2((p.y * 1.0), (tan(min(1.0, (max(1.0, (beats / 36.0)) - 1.0))) / 2.0)), Time).y * 7.0)) / 7.0)), min(1.0, (max(1.0, (beats / 12.0)) - 1.0))).x * 7.0)) / 7.0)), min(1.0, (max(1.0, (beats / 12.0)) - 1.0))).y, (length(p) * 10.0))) * 7.0)) / 7.0)).x), max(1.0, (beats / 12.0))).x) * vec3(0.0, 0.0, 1.0));
vec3 c = clamp(((r + g) + b), 0.1, 1.0);
float cavity = sphereFn((p - vec3(((0.0 + Offset.x) + (sin((beats * 0.5)) - 0.5)), (0.0 + Offset.y), (4.0 - ((max(1.0, (beats / 12.0)) * max(1.0, (beats / 12.0))) * 5.0)))), 2.0);
d = max(d, -cavity);
return vec4(c, d);

}

vec3 march(vec2 uv)
{
vec3 cameraOrigin = vec3(((0.0 + Offset.x) + (sin((beats * 0.5)) - 0.5)), (0.0 + Offset.y), (4.0 - ((max(1.0, (beats / 12.0)) * max(1.0, (beats / 12.0))) * 5.0)));
vec3 cameraTarget = vec3(0.0, 0.0, 0.0);
vec3 upDirection = vec3(0.0, 1.0, 0.0);
vec3 cameraDir = normalize((cameraTarget - cameraOrigin));
vec3 cameraRight = normalize(cross(upDirection, cameraOrigin));
vec3 cameraUp = cross(cameraDir, cameraRight);
vec3 rayDir = normalize((((cameraRight * uv.x) + (cameraUp * uv.y)) + cameraDir));
float MAX_DIST = 10000.0;
float EPSILON = 0.001;
float totalDist = 0.0;
vec3 p = cameraOrigin;
float dist = EPSILON;
vec3 resultColor = vec3(0.0);
for(int index = 0;(index < 1000);index = (index + 1))
{
if (dist < EPSILON || totalDist > MAX_DIST) break;
vec4 result = scene(p);
dist = result.w;
resultColor = result.xyz;
totalDist = (totalDist + dist);
p = (p + (vec3(dist) * rayDir));

}

vec3 c = vec3(0.0);
if(totalDist < MAX_DIST) {;
vec2 eps = vec2(0.0, 0.4);
vec3 normal = normalize(vec3((scene((p + eps.yxx)).w - scene((p - eps.yxx)).w), (scene((p + eps.xyx)).w - scene((p - eps.xyx)).w), (scene((p + eps.xxy)).w - scene((p - eps.xxy)).w)));
float diffuse = max(0.0, dot((-rayDir), normal));
float specular = pow(diffuse, 10.0);
c = (c + (smoothstep(0.0, 1.2, (diffuse + 0.05)) * 0.85));
c = (c + (smoothstep(0.0, 1.0, specular) * 0.1));
c = (sqrt((c - vec3(0.1))) * 1.05);
c = (c * resultColor);
c = (c * clamp(((1.0 / totalDist) + 0.3), 0.0, 1.0));
} else {;
};
return c;

}

void main()
{
vec2 uv = fsin_Position;
uv = vec2((uv.x * 1.777778), uv.y);
uv = vec2((uv.x + ((max(0.0, (0.2 - fract(((beats * 2.0) + 0.04)))) * step(16.0, beats)) * (noise(pR(vec2(uv.y), Time), 0.2) - 0.12))), uv.y);
vec3 c = vec3(0.0);
c = march(uv);

c = clamp(c, 0.0, 1.0);
c -= max(56.6, Time) - 56.6;

fsout_Color = vec4(c, 1.0);

}

