@include screen.h
@include dma.h
@include sound.h


@textarea

SoundOn

S4_Enable
;setup bitmap mode 3
;https://wasm.in/blogs/gba-asm-den-1-postigaem-assembler.271/
ldr r1,=REG_DISPCNT
ldr r2,=(BG2_ENABLE|MODE_3) ; 240x160
str r2,[r1]

;output to screen
;	mov r0, #0x6000000
;	mov r3,160
;ylp:
;	mov r4,240
;xlp:
;;	mov r1,r4 ;r1=r4
;	eor r2,r2,r2
;	and r1,r4,r3;r1=r4 xor r3
;	tst r1,#4
;	orrne r2,r2,#0x1F
;
;	tst r1,#8
;	orrne r2,r2,#0x03E0
;
;	tst r1,#16
;	orrne r2,r2,#0x7C00
;
;	strh r2, [r0], #2;STRH R3,[R4,#14]; Store the halfword in R3 at R14+14 but dont write back.
;	subs r4, r4, #1
;	bne xlp
;
;	subs r3, r3, #1
;	bne ylp

;intro start

ilp:

ldr r0,=#0x4000006     @ VBlank memory address

waitVBlank:
    ldrh r1, [r0]      @ Loads the memory address to the r1 register
    cmp r1, #161       @ Compare if the memory address have completed the VBlank
    bne waitVBlank     @ Loopback until r1 != 161

ldr r1,=VRAM+480     ; \
ldr r0,=REG_DMA3SAD   ; - set the source address in channel 3's source address register
str r1,[r0]           ; /

ldr r1,=VRAM          ; \
ldr r0,=REG_DMA3DAD   ; - set the destination address in channel 3's dest. address register
str r1,[r0]           ; /

ldr r1,=(37920|DMA_16NOW)  ; \
ldr r0,=REG_DMA3CNT       ;  - give the control register the amount of times to copy chunks
; the screen is 240x160=38400, we transfer in 16bit chunks so we don't have to half that 
; number.
str r1,[r0]      ; - DMA transfer starts now, transfers 38400 chunks of 16bit data and 
; the program doesn't actually continue until the DMA is done. But this is pretty fast.

	ldr r0, =VRAM+474*160
	mov r1, 240
;t+(x-t)^(x+t), x=r1,t=r4
llp:
	add r3,r1,r4 ;r3=x+t
	sub r2,r1,r4 ;r2=x-t
	eor r2,r2,r3 ;r2=(x-t)^(x+t)
;	add r2,r2,r4

	mul r2,r2,r4
	MOV r2, r2, ASR #6
	eor r3,r3,r3 ;color

	tst r2,#16
	orrne r3,r3,#0x1F

	tst r2,#32
	orrne r3,r3,#0x03E0

	tst r2,#64
	orrne r3,r3,#0x7C00

	strh r3,[r0],#2
	subs r1,r1,#1
	bne llp
	add r4,r4,#1

;ldr r2,=0xf700
ldr r1,=REG_SOUND4CNT_L  
str r2,[r1]        
 
ldr r1,=REG_SOUND4CNT_H  
str r2,[r1] 

B ilp
 
@pool
@endarea
