#version 450 core

// inputs 
in vec2 texCoord;

// outputs
out vec4 fragColor;

// uniforms
uniform sampler2D   t_texture0;
uniform float       g_time;
uniform float       g_zoomfactor;
uniform float       g_whiteblend;

const int BLUR_SAMPLES = 24;

void main() {
    vec2 uv = texCoord-.5;
  	float radius = dot(uv,uv);

    // "barrel"
    uv *= (0.9 + 0.22*radius);

    // radial blur/chromab (tweakme!)
    vec3 acc  = vec3(0.0);
	vec3 zoom = vec3(1.0, 1.0, 1.0);
    vec3 zoomFactor = mix(vec3(1.), g_zoomfactor*vec3(0.999, .997, .995), (radius/(0.5+radius)));
	
	for (int i = 0 ; i < BLUR_SAMPLES; i++) {
		zoom *= zoomFactor;
		acc.r += texture(t_texture0, (uv*zoom.r + 0.5)).r;
		acc.g += texture(t_texture0, (uv*zoom.g + 0.5)).g;
		acc.b += texture(t_texture0, (uv*zoom.b + 0.5)).b;
	}

    // vingette
	float dim = clamp(1.0 - 0.7*pow(dot(uv, uv), 0.9), 0.0, 1.0);
	
    // small tint
    vec3 tint = mix(vec3(1.0, 0.9, 0.75), vec3(1.), (uv.x+uv.y));
	
    // output + white blend + gamma correction
    fragColor = vec4(pow(mix((acc.rgb / BLUR_SAMPLES) * dim * tint, vec3(1.0), g_whiteblend), vec3(1.0/2.2)), 1.0);
}



