                    !cpu 6510
; ==============================================================================
DEBUG = 0
RELEASE = 1
MODE = 0
; ------------------------------------------------------------------------------
ENABLE              = 0x20
ENABLE_JMP          = 0x4C
DISABLE             = 0x2C

BLACK               = 0x00
WHITE               = 0x01
RED                 = 0x02
CYAN                = 0x03
PURPLE              = 0x04
GREEN               = 0x05
BLUE                = 0x06
YELLOW              = 0x07
ORANGE              = 0x08
BROWN               = 0x09
PINK                = 0x0A
DARK_GREY           = 0x0B
GREY                = 0x0C
LIGHT_GREEN         = 0x0D
LIGHT_BLUE          = 0x0E
LIGHT_GREY          = 0x0F

BORDER_COLOR        = BLACK

MEMCFG              = 0x35
; ------------------------------------------------------------------------------
;                   BADLINEs (0xD011 default)
;                   -------------------------
;                   00 : 0x33
;                   01 : 0x3B
;                   02 : 0x43
;                   03 : 0x4B
;                   04 : 0x53
;                   05 : 0x5B
;                   06 : 0x63
;                   07 : 0x6B
;                   08 : 0x73
;                   09 : 0x7B
;                   10 : 0x83
;                   11 : 0x8B
;                   12 : 0x93
;                   13 : 0x9B
;                   14 : 0xA3
;                   15 : 0xAB
;                   16 : 0xB3
;                   17 : 0xBB
;                   18 : 0xC3
;                   19 : 0xCB
;                   20 : 0xD3
;                   21 : 0xDB
;                   22 : 0xE3
;                   23 : 0xEB
;                   24 : 0xF3
; ------------------------------------------------------------------------------
IRQ_LINE0           = 0xFA
IRQ_LINE1           = 0x82
IRQ_LINE2           = 0xC2
; ------------------------------------------------------------------------------
zp_start            = 0x02
flag_irq_ready      = zp_start
current_mode        = flag_irq_ready+1
pause_flag          = current_mode+1
zp_temp             = pause_flag+1
zp_temp_lo          = zp_temp
zp_temp_hi          = zp_temp+1
pt_charset          = zp_temp_hi+1        ; NEXT: pt_charset+2
pt_screenpos        = pt_charset+2        ; NEXT: pt_screenpos+2
; ------------------------------------------------------------------------------
KEY_CRSRUP          = 0x91
KEY_CRSRDOWN        = 0x11
KEY_CRSRLEFT        = 0x9D
KEY_CRSRRIGHT       = 0x1D
KEY_RETURN          = 0x0D
KEY_STOP            = 0x03

getin               = 0xFFE4
keyscan             = 0xEA87
; ------------------------------------------------------------------------------
vicbank0            = 0x0000
charset0            = vicbank0+0x0800
vidmem0             = vicbank0+0x0400
sprite_data         = vicbank0+0x0FC0
sprite_base         = <((sprite_data-vicbank0)/0x40)
dd00_val0           = <!(vicbank0/0x4000) & 3
d018_val0_lo        = <(((charset0-vicbank0)/0x800) << 1)
d018_val0_hi        = <(((vidmem0-vicbank0)/0x400) << 4)
d018_val0           = d018_val0_hi + d018_val0_lo

music_init          = 0x1000
music_play          = 0x1003
; ==============================================================================
                    !macro flag_set .flag {
                        lda #1
                        sta .flag
                    }
                    !macro flag_clear .flag {
                        lda #0
                        sta .flag
                    }
                    !macro flag_get .flag {
                        lda .flag
                    }
; ==============================================================================
                    *= vidmem0
vidmem_data:        ; 00
                    !byte 0x70,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40
                    !byte 0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40
                    !byte 0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40
                    !byte 0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x6E
                    ; 01 title
                    ;scr 0x5D,"12345678901234567890123456789012345678",0x5D
                    !scr 0x5D,"Vergiftetes Ohrenbonbon               ",0x5D
                    ; 02 (possible second line for title)
                    ;scr 0x5D,"12345678901234567890123456789012345678",0x5D
                    !scr 0x5D,"                                      ",0x5D
                    ; 03
                    !byte 0x5D,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5D
                    ; 04
                    !byte 0x5D,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x63,0x62,0x62,0x64
                    POS_TIME = *
                    ; playlength
                    !scr "00:00<>03:07"
                    !byte 0x63,0x78
                    ; 05
                    !byte 0x5D,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x61,0x20,0x20,0x69,0x62,0x6A,0x64,0x63
                    !byte 0x6A,0x62,0x62,0x6A,0x62,0x6A,0x64,0x63,0x68,0x5D
                    ; 06
                    !byte 0x5D,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x61,0x7B,0x7B,0x61,0x7B,0x61,0x65,0x66
                    !byte 0x6B,0x6F,0x20,0x61,0x7B,0x61,0x65,0x66,0x61,0x5D
                    ; 07
                    !byte 0x5D
                    ;scr "                     "
                    !scr "by Spider Jerusalem  "
                    !byte 0x61,0x61,0x61,0x61,0x20,0x6B,0x6F,0x75
                    !byte 0x76,0x61,0x7B,0x61,0x20,0x6B,0x6F,0x75,0x67,0x73
                    ; 08
                    !byte 0x5D
                    ;scr "                     "
                    !scr "    8580, GoatTracker"
                    !byte 0x61,0x61,0x61,0x61,0x7B,0x74,0x61,0x74
                    !byte 0x63,0x79,0x20,0x61,0x7B,0x74,0x61,0x74,0x63,0x78
                    ; 09
                    !byte 0x6D,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40
                    !byte 0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40
                    !byte 0x40,0x40,0x71,0x71,0x71,0x71,0x71,0x77,0x71,0x77
                    !byte 0x71,0x40,0x40,0x71,0x71,0x77,0x71,0x77,0x71,0x7D
                    ; 10
                    POS_SCROLLER = *
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    ; 11
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    ; 12
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    ; 13
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    ; 14
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    ; 15
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    ; 16
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    ; 17
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    ; 18
                    !byte 0x70,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40
                    !byte 0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40
                    !byte 0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40
                    !byte 0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x6E
                    ; 19
                    !byte 0x5D,0xC6,0xB1,0x3A,0x20,0x53,0x17,0x09,0x14,0x03
                    !byte 0x08,0x20,0x43,0x0F,0x0D,0x10,0x0F,0x20,0x2F,0x20
                    !byte 0x4C,0x0F,0x0F,0x10,0x20,0x4D,0x0F,0x04,0x05,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5D
                    ; 20
                    !byte 0x5D,0xC6,0xB3,0x3A,0x20,0x52,0x05,0x13,0x14,0x01
                    !byte 0x12,0x14,0x20,0x54,0x15,0x0E,0x05,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5D
                    ; 21
                    !byte 0x5D,0xC6,0xB5,0x3A,0x20,0x50,0x01,0x15,0x13,0x05
                    !byte 0x20,0x2F,0x20,0x52,0x05,0x13,0x15,0x0D,0x05,0x20
                    !byte 0x54,0x15,0x0E,0x05,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5D
                    ; 22
                    !byte 0x5E,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40
                    !byte 0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40
                    !byte 0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40
                    !byte 0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x5C
                    ; 23
                    !byte 0x5D,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
                    !byte 0x43,0x15,0x12,0x12,0x05,0x0E,0x14,0x20,0x4D,0x0F
                    !byte 0x04,0x05,0x3A,0x20
                    POS_MODE = *
                    !if MODE = 0 {
                        !scrxor 0x80, "Compo"
                    } else {
                        !scrxor 0x80, "Loop!"
                    }
                    !byte 0x5D
                    ; 24
                    !byte 0x6D,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40
                    !byte 0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40
                    !byte 0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40
                    !byte 0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x7D

                    *= music_init
                    !bin "../sid/Vergiftetes_Ohrenbonbon.sid",,0x7E
                    code_start = *

                    *= charset0
                    !bin "mplayerchar.chr",0x7C0

                    *= sprite_data
                    !bin "sprite.bin"
; ==============================================================================
                    *= code_start
                    lda #0x7F
                    sta 0xDC0D
                    lda #MEMCFG
                    sta 0x01
                    lda #0x0B
                    sta 0xD011
                    jmp init_code
; ==============================================================================
                    !zone IRQ
                    NUM_IRQS = 0x03
irq:                !if MEMCFG = 0x35 {
                        sta .irq_savea+1
                        stx .irq_savex+1
                        sty .irq_savey+1
                        lda 0x01
                        sta .irq_save0x01+1
                        lda #0x35
                        sta 0x01
                    }
irq_next:           jmp irq0
irq_end:            lda 0xD012
-                   cmp 0xD012
                    beq -
.irq_index:         ldx #0
                    lda irq_tab_lo,x
                    sta irq_next+1
                    lda irq_tab_hi,x
                    sta irq_next+2
                    lda irq_lines,x
                    sta 0xD012
                    inc .irq_index+1
                    lda .irq_index+1
                    cmp #NUM_IRQS
                    bne +
                    lda #0
                    sta .irq_index+1
+                   asl 0xD019
                    !if MEMCFG = 0x37 {
                        jmp 0xEA31
                    }
                    !if MEMCFG = 0x36 {
                        jmp 0xEA81
                    }
                    !if MEMCFG = 0x35 {
.irq_save0x01:          lda #0x35
                        sta 0x01
                        cmp #0x36
                        beq +
.irq_savea:             lda #0
.irq_savex:             ldx #0
.irq_savey:             ldy #0
                        rti
+                       jmp 0xEA81
                    }

irq0:               +flag_set flag_irq_ready
                    lda #PURPLE
                    ldx #4
-                   dex
                    bpl -
                    sta 0xD020
enable_music:       jsr music_play
                    lda #BORDER_COLOR
                    sta 0xD020

                    lda 0x138D
                    sta 0xD027

                    lda 0x13BF
                    lsr
                    ora #8
                    sta 0xD028

                    lda 0x13CD
                    ora 0x13AA
                    sta 0xD029

enable_timer:       jsr timer
                    jsr check_end
                    !if DEBUG=1 { inc 0xD020 }
                    jsr anim_textborder
                    !if DEBUG=1 { dec 0xD020 }
                    jmp irq_end

irq1:               ldx #0x02
-                   dex
                    bpl -
                    lda 0xD016
                    and #%11110000
                    ora d016_bits012
                    sta 0xD016
                    jmp irq_end

irq2:               ldx #0x02
-                   dex
                    bpl -
                    lda #%00001000
                    sta 0xD016
                    jsr anim_scrollchar
                    jmp irq_end

irq_tab_lo:         !byte <irq1, <irq2, <irq0
irq_tab_hi:         !byte >irq1, >irq2, >irq0
irq_lines:          !byte IRQ_LINE1, IRQ_LINE2, IRQ_LINE0
; ==============================================================================
init_code:          jsr init_nmi
                    jsr init_zp
                    jsr init_vic
                    jsr init_music
                    jsr init_irq
                    jmp mainloop

init_irq:           lda irq_lines
                    sta 0xD012
                    lda #<irq
                    sta 0x0314
                    !if MEMCFG = 0x35 {
                        sta 0xFFFE
                    }
                    lda #>irq
                    sta 0x0315
                    !if MEMCFG = 0x35 {
                        sta 0xFFFF
                    }
                    lda 0xD011
                    and #%01101111
                    ora #%00010000
                    sta 0xD011
                    lda #0x01
                    sta 0xD019
                    sta 0xD01A
                    rts

init_music:         lda #0
                    tay
                    tax
                    jsr 0x1000
                    rts

init_nmi:           lda #<nmi
                    sta 0x0318
                    !if MEMCFG = 0x35 {
                        sta 0xFFFA
                    }
                    lda #>nmi
                    sta 0x0319
                    !if MEMCFG = 0x35 {
                        sta 0xFFFB
                    }
                    rts

init_vic:           lda #dd00_val0
                    sta 0xDD00
                    lda #d018_val0
                    sta 0xD018
                    lda #BORDER_COLOR
                    sta 0xD020
                    lda #BLACK
                    sta 0xD021

                    ldx #0
-                   lda colram_data+0x000,x
                    sta 0xD800+0x000,x
                    lda colram_data+0x100,x
                    sta 0xD800+0x100,x
                    lda colram_data+0x200,x
                    sta 0xD800+0x200,x
                    lda colram_data+0x2e8,x
                    sta 0xD800+0x2e8,x
                    inx
                    bne -

                    ; sprites
                    lda #sprite_base
                    sta vidmem0+0x3F8
                    sta vidmem0+0x3F9
                    sta vidmem0+0x3FA
                    lda #0x38
                    sta 0xD000
                    lda #0x68
                    sta 0xD002
                    lda #0x98
                    sta 0xD004
                    lda #0x4C
                    sta 0xD001
                    sta 0xD003
                    sta 0xD005
                    lda #DARK_GREY
                    sta 0xD027
                    sta 0xD028
                    sta 0xD029
                    lda #0x00
                    sta 0xD010
                    sta 0xD017
                    sta 0xD01D
                    lda #0x07
                    sta 0xD015
                    rts

init_zp:            lda #0
                    sta pause_flag
                    lda #MODE
                    sta current_mode
                    rts
; ==============================================================================
                    !zone MAINLOOP
mainloop:           jsr wait_irq
is_end:             lda #0
                    beq +
                    lda #0
                    sta is_end+1
                    jsr init_music
+                   jsr keyboard_get

                    !if DEBUG=1 {
                        lda #LIGHT_BLUE
                        sta 0xD020
                    }
                    jsr scroller
                    !if DEBUG=1 {
                        lda #BORDER_COLOR
                        sta 0xD020
                    }

                    jmp mainloop
; ==============================================================================
                    !zone NMI
nmi:                lda #0x37               ; restore 0x01 standard value
                    sta 0x01
                    lda #0                  ; if AR/RR present
                    sta 0xDE00              ; reset will lead to menu
                    jmp 0xFCE2              ; reset
; ==============================================================================
                    !zone WAIT
wait_irq:           +flag_clear flag_irq_ready
.wait_irq:          +flag_get flag_irq_ready
                    beq .wait_irq
                    rts
; ==============================================================================
                    !zone TIMER
                    t0 = POS_TIME+0x4
                    t1 = POS_TIME+0x3
                    t2 = POS_TIME+0x1
                    t3 = POS_TIME+0x0
                    SECONDS_VAL = 49
timer:              lda #SECONDS_VAL
                    beq +
                    dec timer+1
                    rts
+                   lda #SECONDS_VAL
                    sta timer+1
                    clc
                    inc t0
                    lda t0
                    cmp #0x3A
                    bne +
                    lda #0x30
                    sta t0
                    inc t1
                    lda t1
                    cmp #0x36
                    bne +
                    lda #0x30
                    sta t1
                    inc t2
                    lda t2
                    cmp #0x3A
                    bne +
                    lda #0x30
                    sta t2
                    inc t3
                    lda t3
                    cmp #0x3A
                    bne +
                    lda #0x30
                    sta t3
+                   rts
                    e0 = POS_TIME+0xB
                    e1 = POS_TIME+0xA
                    e2 = POS_TIME+0x8
                    e3 = POS_TIME+0x7
check_end:          !if MODE = 1 {
                        rts
                    } else {
                        nop
                    }
                    lda t3
                    cmp e3
                    bne +
                    lda t2
                    cmp e2
                    bne +
                    lda t1
                    cmp e1
                    bne +
                    lda t0
                    cmp e0
                    bne +
                    lda #DISABLE
                    sta enable_music
                    sta enable_timer
                    lda #1
                    sta is_end+1
+                   rts
; ==============================================================================
                    !zone ANIMATION
anim_textborder:    ; reset textborder color
                    lda #BLUE
                    !for i, 0, 39 {
                        sta 0xD800+i
                        sta 0xD800+(9*40)+i
                        sta 0xD800+(18*40)+i
                        sta 0xD800+(22*40)+i
                        sta 0xD800+(24*40)+i
                    }
                    !for i, 1, 8 {
                        sta 0xD800+(i*40)
                        sta 0xD800+(i*40)+39
                    }
                    sta 0xD800+(19*40)
                    sta 0xD800+(19*40)+39
                    sta 0xD800+(20*40)
                    sta 0xD800+(20*40)+39
                    sta 0xD800+(21*40)
                    sta 0xD800+(21*40)+39
                    sta 0xD800+(23*40)
                    sta 0xD800+(23*40)+39

                    ; rotate coltab top
                    lda coltab_t
                    sta .savecol_t+1
                    !for i, 0, 0x5E {
                        lda coltab_t+i+1
                        sta coltab_t+i
                    }
.savecol_t:         lda #0
                    sta coltab_t+0x5F

                    ; rotate coltab bottom
                    lda coltab_b
                    sta .savecol_b+1
                    !for i, 0, 0xA6 {
                        lda coltab_b+i+1
                        sta coltab_b+i
                    }
.savecol_b:         lda #0
                    sta coltab_b+0xA7

                    ; check coltab_t and write to colram if result < 0x80
                    ldx #coltab_t_len
-                   lda coltab_t,x
                    bpl .write_t
.next_t:            dex
                    bpl -

                    ; check coltab_b and write to colram if result < 0x80
                    ldx #coltab_b_len
-                   lda coltab_b,x
                    bpl .write_b
.next_b:            dex
                    cpx #0xFF
                    bne -
                    rts

.write_t:           pha
                    lda colpostab_t_lo,x
                    sta .dest_t+1
                    lda colpostab_t_hi,x
                    sta .dest_t+2
                    pla
.dest_t:            sta 0x0000
                    jmp .next_t

.write_b:           pha
                    lda colpostab_b_lo,x
                    sta .dest_b+1
                    lda colpostab_b_hi,x
                    sta .dest_b+2
                    pla
.dest_b:            sta 0x0000
                    jmp .next_b
; ------------------------------------------------------------------------------
; scroller chars:   0xF0, 0xF1, 0xF2, 0xF3, 0xF4
; target char:      0x5F
                    ANIM_SCROLLCHAR_SPEED = 6
anim_scrollchar:    lda #ANIM_SCROLLCHAR_SPEED
                    beq +
                    dec anim_scrollchar+1
                    rts
+                   lda #ANIM_SCROLLCHAR_SPEED
                    sta anim_scrollchar+1
.savex:             ldx #0x00
                    lda .source_chars_lo,x
                    sta zp_temp_lo
                    lda .source_chars_hi,x
                    sta zp_temp_hi
                    ldy #0x07
-                   lda (zp_temp),y
                    sta charset0+(0x5F*8),y
                    dey
                    bpl -
                    inx
                    cpx #0x0A
                    bne +
                    ldx #0x00
+                   stx .savex+1
                    rts
.source_chars_lo:   !byte <(charset0+(0xF0*8))
                    !byte <(charset0+(0xF1*8))
                    !byte <(charset0+(0xF2*8))
                    !byte <(charset0+(0xF3*8))
                    !byte <(charset0+(0xF4*8))
                    !byte <(charset0+(0xF4*8))
                    !byte <(charset0+(0xF3*8))
                    !byte <(charset0+(0xF2*8))
                    !byte <(charset0+(0xF1*8))
                    !byte <(charset0+(0xF0*8))
.source_chars_hi:   !byte >(charset0+(0xF0*8))
                    !byte >(charset0+(0xF1*8))
                    !byte >(charset0+(0xF2*8))
                    !byte >(charset0+(0xF3*8))
                    !byte >(charset0+(0xF4*8))
                    !byte >(charset0+(0xF4*8))
                    !byte >(charset0+(0xF3*8))
                    !byte >(charset0+(0xF2*8))
                    !byte >(charset0+(0xF1*8))
                    !byte >(charset0+(0xF0*8))
; ==============================================================================
                    !zone KEYBOARD
keyboard_get:
.debounce:          lda #0
                    beq +
                    dec .debounce+1
                    rts
+                   lda #0x00             ; set data direction for keyboard
                    sta 0xDC03            ; PORT B : INPUT
                    lda #0xFF
                    sta 0xDC02            ; PORT A : OUTPUT
.key_f1:            lda #%11111110        ; check keyboard for
                    sta 0xDC00            ; F1

                    lda 0xDC01
                    and #%00010000
                    sta 0xDC01
                    bne .key_f3           ; no -> skip
                                          ; yes:
                    lda POS_MODE+0        ; change current mode screen text
                    eor #('C' XOR 'L')
                    sta POS_MODE+0

                    lda POS_MODE+2
                    eor #('m' XOR 'o')
                    sta POS_MODE+2

                    lda POS_MODE+4
                    eor #('o' XOR 'A')
                    sta POS_MODE+4

                    lda current_mode      ; change current mode flag
                    eor #(0 XOR 1)
                    sta current_mode

                    lda check_end         ; switch end check routine
                    eor #(0x60 XOR 0xea)  ; RTS or NOP
                    sta check_end

                    lda enable_music
                    cmp #DISABLE          ; check if music has already ended
                    bne +                 ; if no -> skip

                    lda pause_flag        ; if yes: check pause flag
                    bne +                 ; if set -> skip
                    jmp .restart          ; if not set -> restart tune
+                   jmp .exit

.key_f3:            lda #%11111110        ; check keyboard for
                    sta 0xDC00            ; F3

                    lda 0xDC01
                    and #%00100000
                    sta 0xDC01
                    bne .key_f5           ; no -> skip
.restart:                                 ; yes:
                    jsr tune_restart      ; restart tune
                    jmp .exit

.key_f5:            lda #%11111110        ; check keyboard for
                    sta 0xDC00            ; F5

                    lda 0xDC01
                    and #%01000000
                    sta 0xDC01
                    bne ++

                    lda enable_music
                    eor #(ENABLE XOR DISABLE)
                    sta enable_music

                    lda enable_timer
                    eor #(ENABLE XOR DISABLE)
                    sta enable_timer

                    lda pause_flag
                    eor #(0 XOR 1)
                    sta pause_flag

                    lda enable_music
                    cmp #DISABLE
                    bne +

                    lda #0x00
                    sta 0xD418
+
.exit:              lda #0x10
                    sta .debounce+1
++                  rts
; ==============================================================================
tune_restart:       sei
                    lda #0x0B
                    sta 0xD011

                    jsr init_music

                    lda #0
                    sta pause_flag        ; clear pause flag

                    lda #'0'              ; reset min/sec counter
                    sta t0
                    sta t1
                    sta t2
                    sta t3

                    lda #49               ; reset frames counter
                    sta timer+1

                    lda #ENABLE           ; enable music and counter
                    sta enable_music
                    sta enable_timer

                    lda current_mode      ; check current mode
                    beq +
                    lda #0x60             ; if 1 (loop) -> RTS
                    !byte 0x2C
+                   lda #0xEA             ; if 0 (compo) -> NOP
                    sta check_end         ; at the start of check end routine

                    lda #0x1B
                    sta 0xD011
                    asl 0xD019
                    cli
                    rts
; ==============================================================================
                    !zone SCROLLER
scroller:
.need_new:          lda #0
                    cmp #8
                    bne +
                    lda #0
                    sta .need_new+1
                    jsr .get_text
                    jsr .new_char
+
.scroll:            lda #0x07
                    sec
                    sbc #0x04
                    bcs +
                    jsr .hardscroll
                    lda #0x07
+                   sta .scroll+1
                    sta d016_bits012
                    rts

.get_text:
.pt_scrolltext:     lda scrolltext
                    cmp #0xff
                    beq .text_reset
                    tay
                    clc
                    lda .pt_scrolltext+1
                    adc #0x01
                    sta .pt_scrolltext+1
                    lda .pt_scrolltext+2
                    adc #0x00
                    sta .pt_scrolltext+2
                    tya
                    rts
.text_reset:        lda #<scrolltext
                    sta .pt_scrolltext+1
                    lda #>scrolltext
                    sta .pt_scrolltext+2
                    lda #' '
                    rts
.new_char:          tay
                    lda #0x00
                    sta pt_charset
                    lda #0x08
                    sta pt_charset+1

                    lda #0
                    sta .char_hi+1

                    tya
                    asl
                    rol .char_hi+1
                    asl
                    rol .char_hi+1
                    asl
                    rol .char_hi+1
                    clc
                    adc pt_charset
                    sta pt_charset

.char_hi:           lda #0
                    adc pt_charset+1
                    sta pt_charset+1
                    !if DEBUG = 1 {
                        lda pt_charset
                        sta 0x0400
                        lda pt_charset+1
                        sta 0x0401
                    }
                    ldy #0x07
-                   lda (pt_charset),y
                    sta .charbuffer,y
                    dey
                    bpl -
                    rts

.hardscroll:        lda #<POS_SCROLLER
                    sta pt_screenpos
                    lda #>POS_SCROLLER
                    sta pt_screenpos+1

                    ldx #0x00
-                   ldy #' '
                    asl .charbuffer,x
                    bcc +

                    ldy #0x5F
+                   tya
                    ldy #0x27
                    sta (pt_screenpos),y

                    clc
                    lda pt_screenpos
                    adc #0x28
                    sta pt_screenpos
                    bcc +
                    inc pt_screenpos+1
+                   inx
                    cpx #0x08
                    bne -

                    !for i, 0, 0x26 {
                        !for j, 0, 7 {
                            lda POS_SCROLLER+(j*40)+1+i
                            sta POS_SCROLLER+(j*40)+i
                        }
                    }

                    inc .need_new+1
                    rts
.charbuffer:        !byte 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
d016_bits012:       !byte 0x00
; ==============================================================================
                    !zone DATA
; ------------------------------------------------------------------------------
                    ; BLACK               = @
                    ; WHITE               = a
                    ; RED                 = b
                    ; CYAN                = c
                    ; PURPLE              = d
                    ; GREEN               = e
                    ; BLUE                = f
                    ; YELLOW              = g
                    ; ORANGE              = h
                    ; BROWN               = i
                    ; PINK                = j
                    ; DARK_GREY           = k
                    ; GREY                = l
                    ; LIGHT_GREEN         = m
                    ; LIGHT_BLUE          = n
                    ; LIGHT_GREY          = o
colram_data:        ;scr "0123456789012345678901234567890123456789"
                    !scr "ffffffffffffffffffffffffffffffffffffffff" ; 00
                    !scr "fggggggggggggggggggggggggggggggggggggggf" ; 01
                    !scr "fggggggggggggggggggggggggggggggggggggggf" ; 02
                    !scr "f@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@f" ; 03
                    !scr "f@@@@@@@@@@@@@@@@@@@@@ffffmmammffggaggff" ; 04
                    !scr "f@@@@@@@@@@@@@@@@@@@@@dddddddddddddddddf" ; 05
                    !scr "f@@@@@@@@@@@@@@@@@@@@@nnnnnnnnnnnnnnnnnf" ; 06
                    !scr "fjjjjjjjjjjjjjjjjjjjjjcccccccccccccccccf" ; 07
                    !scr "fdddddddddddddddddddddooooooooooooooooof" ; 08
                    !scr "ffffffffffffffffffffffffffffffffffffffff" ; 09
                    !scr "gggggggggggggggggggggggggggggggggggggggg" ; 10
                    !scr "gggggggggggggggggggggggggggggggggggggggg" ; 11
                    !scr "gggggggggggggggggggggggggggggggggggggggg" ; 12
                    !scr "gggggggggggggggggggggggggggggggggggggggg" ; 13
                    !scr "gggggggggggggggggggggggggggggggggggggggg" ; 14
                    !scr "gggggggggggggggggggggggggggggggggggggggg" ; 15
                    !scr "gggggggggggggggggggggggggggggggggggggggg" ; 16
                    !scr "gggggggggggggggggggggggggggggggggggggggg" ; 17
                    !scr "ffffffffffffffffffffffffffffffffffffffff" ; 18
                    !scr "fccadddddddddddddddddddddddddddddddddddf" ; 19
                    !scr "fddannnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnf" ; 20
                    !scr "fnnacccccccccccccccccccccccccccccccccccf" ; 21
                    !scr "ffffffffffffffffffffffffffffffffffffffff" ; 22
                    !scr "fjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjalcccccf" ; 23
                    !scr "ffffffffffffffffffffffffffffffffffffffff" ; 24
; ------------------------------------------------------------------------------
coltab_t:           !byte PURPLE,LIGHT_BLUE,CYAN,WHITE,CYAN,LIGHT_BLUE,PURPLE
                    !fi 41, 0x80
                    !byte PURPLE,LIGHT_BLUE,CYAN,WHITE,CYAN,LIGHT_BLUE,PURPLE
                    !fi 41, 0x80
coltab_t_end:       coltab_t_len = coltab_t_end-1-coltab_t
; ------------------------------------------------------------------------------
colpostab_t_lo:     !for i, 0, 39 {
                        !byte <(0xD800+i)
                    }
                    !for i, 1, 8 {
                        !byte <(0xD800+(i*40)+39)
                    }
                    !for i, 39, 0 {
                        !byte <(0xD800+(9*40)+i)
                    }
                    !for i, 8, 1 {
                        !byte <(0xD800+(i*40))
                    }
colpostab_t_hi:     !for i, 0, 39 {
                        !byte >(0xD800+i)
                    }
                    !for i, 1, 8 {
                        !byte >(0xD800+(i*40)+39)
                    }
                    !for i, 39, 0 {
                        !byte >(0xD800+(9*40)+i)
                    }
                    !for i, 8, 1 {
                        !byte >(0xD800+(i*40))
                    }
; ------------------------------------------------------------------------------
coltab_b:           !byte PURPLE,LIGHT_BLUE,CYAN,WHITE,CYAN,LIGHT_BLUE,PURPLE
                    !fi 161, 0x80
coltab_b_end:       coltab_b_len = coltab_b_end-1-coltab_b
; ------------------------------------------------------------------------------
colpostab_b_lo:     !for i, 0, 39 {
                        !byte <(0xD800+(18*40)+i)
                    }
                    !byte <(0xD800+(19*40)+39)
                    !byte <(0xD800+(20*40)+39)
                    !byte <(0xD800+(21*40)+39)
                    !for i, 39, 0 {
                        !byte <(0xD800+(22*40)+i)
                    }
                    !byte <(0xD800+(23*40))
                    !for i, 0, 39 {
                        !byte <(0xD800+(24*40)+i)
                    }
                    !byte <(0xD800+(23*40)+39)
                    !for i, 39, 0 {
                        !byte <(0xD800+(22*40)+i)
                    }
                    !byte <(0xD800+(21*40))
                    !byte <(0xD800+(20*40))
                    !byte <(0xD800+(19*40))
colpostab_b_hi:     !for i, 0, 39 {
                        !byte >(0xD800+(18*40)+i)
                    }
                    !byte >(0xD800+(19*40)+39)
                    !byte >(0xD800+(20*40)+39)
                    !byte >(0xD800+(21*40)+39)
                    !for i, 39, 0 {
                        !byte >(0xD800+(22*40)+i)
                    }
                    !byte >(0xD800+(23*40))
                    !for i, 0, 39 {
                        !byte >(0xD800+(24*40)+i)
                    }
                    !byte >(0xD800+(23*40)+39)
                    !for i, 39, 0 {
                        !byte >(0xD800+(22*40)+i)
                    }
                    !byte >(0xD800+(21*40))
                    !byte >(0xD800+(20*40))
                    !byte >(0xD800+(19*40))
; ------------------------------------------------------------------------------
scrolltext:         !scr "Yours spider not so proudly presents to you: "
                    !scr 0x22, "Vergiftetes Ohrenbonbon", 0x22, " "
                    !scr "Hellau Evoke. Mer lasse den Dom in Koelle ... "
                    !scr "Okay this should be enough compliment fishing. "
                    !scr "This is my little contribution to the Alternative "
                    !scr "Platforms "
                    !scr "competition. A c64 tune that is based on the idea "
                    !scr "to just repeat voice 1 and to go crazy on the other "
                    !scr "voices. So just sit down, relax and just ignore "
                    !scr "what is happening to your ears. "
                    !scr "STAY CALM! It will be over soon. The relief will "
                    !scr "be better than the pain. "
                    !scr "Personal greetings go out to: Tennissocke, "
                    !scr "Bratpfannenhubert and Brutzelbernie. You guys "
                    !scr "know who you are! "
                    !scr "     ...     "
                    !byte 0xFF
; ==============================================================================
!eof

0x70: Ecke oben links
0x40: horizontal
0x6E: Ecke oben rechts
0x5D: vertikal
0x6D: Ecke unten links
0x7D: Ecke unten rechts

scroller chars: 0xF0, 0xF1, 0xF2, 0xF3, 0xF4
target char: 0x5F
