#extension GL_EXT_gpu_shader4 : enable
// Compofiller Studio by Yzi 2018
//
// Default template shader

// This shader program is executed in the GPU (or a CPU-based emulation) for
// every pixel (i.e. "fragment" in OpenGL jargon) of every frame.

// The "uniforms" are the same (i.e. uniform) for all pixels/fragments of the frame,
// and they come from the main program.
uniform float time;
uniform vec2 resolution;

// If you choose to save some bytes and not use either of these uniforms, you have to
// do some additional tricks.
//   * time : if you uncheck "[ ] Use time uniform" checkbox, time is in gl_Color.y (green component)
//   * resolution : if you uncheck "[ ] Use resolution uniform" checkbox, you'll have to hard-code the resolution manually

// The uniform-less version could look like this, 88200.0 being the time divider
//float time = gl_Color.y * 256.0 * (65536.0 / 88200.0);
//vec2 resolution = vec2(1280.0, 720.0);

// Uncomment this to use the texture-based features
uniform sampler2D texture_sampler;

// Uncomment this to use the texture-based features
uniform sampler2D texts;

// ======================
float sdCircle( in vec2 p, in float r ) {
    return length(p)-r;
}

float sdBox( in vec2 p, in vec2 b ){
    vec2 d = abs(p)-b;
    return length(max(d,0.0)) + min(max(d.x,d.y),0.0);
}

float sdSegment( in vec2 p, in vec2 a, in vec2 b ){ // a:start pos, b:end pos
    vec2 pa = p-a, ba = b-a;
    return length( pa - ba*clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 ) );
}
    float d;
   vec3 col; // background

void setcol()
{
        if (d<=0.0)
            col=vec3(1.0);
        else if (d<=0.1)
            col=vec3(smoothstep(1.0,0.0,10.0*d));
}

void main()
{
   float iTime = time*2.5;
   vec2 p = (2.0*gl_FragCoord.xy-resolution)/resolution.y;
    vec2 porig = p;

    p.x += mod(iTime, 5.0)-2.5;
    int phase = int(iTime/5.0);

    d = sdCircle(p,0.5);
    switch (phase)
    {
        case 0: // text
        case 1:
        case 28:
               col = texture2D(texts, (gl_FragCoord.xy / resolution) - vec2(0., -.5)).xyz;
        break;

        case 2: // növekvő kör
        float r = iTime/10.0-1.0;
        d = sdCircle(p,r);
        setcol(); if (d<=r/10.0)
            col=vec3(smoothstep(1.0,0.0,10.0*d));
        break;

        case 5: // lyukas
        if ((d<=0.0) && (d>-0.25))
            col=vec3(1.0);
        else if ((d>0.0) && (d<=0.1))
            col=vec3(smoothstep(1.0,0.0,10.0*(d)));
        else if ((d<=-0.25)&&(d>-0.35))
            col=vec3(smoothstep(1.0,0.0,1.0-10.0*(d+0.35)));
        break;

        case 6: // függőleges csík
        d = sdCircle(p.xx,0.5);
        setcol();
        break;

        case 8: // átlós
        p.y = p.y+mod(iTime, 5.0)-2.5;
        d = sdCircle(p,0.5);
        setcol();
        break;

        case 9: // körök egymás fölött
        p.y = mod(p.y-0.6,1.2)-0.6;
        d = sdCircle(p,0.5);
        setcol();
        break;

        case 11: // fogaskerék
        if (d<=0.0)
            col=vec3(1.0);
        else if (d<=0.1)
        {
            //float pixel_angle = atan(p.x,p.y) ;
            //float pixel_distance =  length(uv)* 2.0 ;
            //if(pixel_angle>0.0)
            //            col=vec3(1.0);
            col=vec3(mod((atan(p.x,p.y)+iTime/1.5)*4.0,1.0)>0.5?1.0:0.0);
        }
        break;

        case 12: // visszafelé
        p.x = porig.x-mod(iTime, 5.0)+2.5;
        d = sdCircle(p,0.5);
        setcol();
        break;

        case 13: // doboz
        d = sdBox(p,vec2(0.5));
        setcol();
        break;

        case 15: // kör-doboz
        d = max(-sdBox(p,vec2(0.25)), sdCircle(p,0.5));
        setcol();
        break;

        case 16: // ying-yang
        if (d<=0.0)
        {
            if((bool(sin(p.y*6.0)<p.x*3.14) || (sdCircle(p-vec2(0.0, 0.25),0.1)<0.0)) && (sdCircle(p-vec2(0.0,-0.25),0.1)>0.0))
                  col=vec3(1.0);
        }
        else if (d<=0.1)
            col=vec3(smoothstep(1.0,0.0,10.0*d));
        break;

        case 17: // napfogyatkozás
        d = max(-sdCircle(porig,0.6),d);
        setcol();
        break;

        case 20: // C64=
        if((abs(porig.x)>1.2)||(abs(porig.y)>0.8))
                col=vec3(0.525, 0.478, 0.870);
        else
        {
            if (d<=0.0)
                col=vec3(1.0);
            else
            {
               col=vec3(0.281, 0.226, 0.664);
               if (d<=0.1)
                 col+=smoothstep(1.0,0.0,10.0*d);
            }
        }
        break;

        case 21: // amiga
        setcol();
        if (d<=0.0)
        {
            col=((int(mod(p.y*6.0,2.0)>=1.0)^int(mod(p.x/(0.75-(p.y*p.y))*6.0,2.0)>=1.0))>0 )?vec3(1.0):vec3(1.0, 0.0, 0.0);
        }
        break;

        case 22: // összeolvad
        p.x = abs(porig.x)+mod(iTime, 5.0)-2.5;
        d = sdCircle(p,0.5);
        setcol();
        break;

        case 23: // noise
        if (d<=0.0)
            col = vec3(fract(sin(dot(p, vec2(12.98, 78.23))) * 437.54));
        else if (d<=0.1)
            col=vec3(smoothstep(fract(sin(dot(p, vec2(12.98, 78.23))) * 437.54),0.0,10.0*d));
        break;

        case 24: // visszapattan
        if(mod(iTime, 5.0)>2.5)
            p.x = porig.x-mod(iTime, 5.0)+2.5; // vissza

        d = sdCircle(p,0.5);
        setcol();
        break;

        case 25: // firg
        p.x=abs(p.x);
        d = max(-(sdCircle( p-vec2( 0.0, 0.22),0.15)), d); // fej
        d = max(-(sdSegment(p,vec2( 0.0, 0.1),vec2( 0.2, 0.1+0.05*sin(iTime*12.0)))-0.1), d); // karok
        d = max(-(sdSegment(p,vec2( 0.0,-0.1),vec2( 0.0, 0.1))-0.1), d); // törzs
        d = max(-(sdSegment(p,vec2( 0.2,-0.3),vec2( 0.0,-0.1))-0.1), d); // lábak
        setcol();
        break;

        default:
        setcol();
        if(phase==4)
                col = 1.0 - col;
        if(phase==27)
                col.yz=vec2(0.0);

    }

	gl_FragColor = vec4(col,1.0);
}
  //globalfade = smoothstep(0.0, 1.0, bar); // fade in

