#version 330 core
layout (location = 0) in vec3 aPos;
layout (location = 1) in vec3 aColor;
layout (location = 2) in vec3 aPos2;
layout (location = 3) in vec3 aColor2;


// for this testX:
out vec4 vertexColor;
out vec4 vertexColor2;
out float PS;
out vec4 glitch;
uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;
uniform float time;
void main()
{
	gl_PointSize = (step(sin(aColor.y)*.1, aColor.x * aPos.y) * sin(aPos.y + gl_VertexID)) * 15.; 
	PS = 0.2 - gl_PointSize -radians(aPos.z);
	gl_PointSize *= sin(time) + radians(vertexColor2.y - 0.2);
	vertexColor = vec4(aColor, 1.0);
	vertexColor2 = vec4(aColor2, 1.0);
	vec4 box1 = projection * view * model * vec4(aPos, 1.0f);
	vec4 box2 = projection * view * model * vec4(aPos2, 1.0f);
	vec4 box3 = box1 / distance( vec4(aPos2, 0.7f), vec4(faceforward(aPos.z, aPos.y, aPos2.x)));
	vec4 box4 = box2 + dot(aPos, aPos2)- (length(gl_VertexID *aColor.y)) + (gl_VertexID * aPos.x);

	
	gl_Position = mix(box3, box4, (sin(time)*.5));
	vec4 glitch = abs(gl_Position);
	//gl_Position = projection * view * model * vec4(aPos, 1.0f);
	//TexCoord = vec2(aTexCoord.x, aTexCoord.y);

}

