#version 330 core
out vec4 FragColor;

in vec3 ourColor;
in vec2 TexCoord;
in vec4 glitch;
uniform vec2 u_resolution;
uniform float time;

// texture sampler
uniform sampler2D texture1;

void main()
{
	vec2 coffee = vec2(TexCoord.x / normalize (glitch.x), TexCoord.y / sin(gl_FragDepth));
	if(time > 12)
	{
	FragColor = texture(texture1, TexCoord);
	//* sin(gl_FragDepth), TexCoord.y * normalize(glitch));
	}
	
	if(time < 12)
	{
	FragColor = texture(texture1, TexCoord) *distance(ourColor.y, gl_FragDepth * 20. );
	}
}