PGraphics buffer;
PGraphics h, v;

int MODO = 0;
boolean byn = false;

void setup() {
  // size(640, 480, P2D);
  fullScreen(P2D);

  buffer = createGraphics(640, 480);
  h = createGraphics(buffer.width, 1);
  v = createGraphics(1, buffer.height);

  background(0);
  wave = new float[buffer.width];
}

void draw() {

  if (frameCount % 15 == 0 && random(1) < 0.4) {
    MODO = floor(random(4));
    updateWave(floor(random(60, 240)));
  }

  if (frameCount % 120 == 0) {
    if (random(1) < 0.35) byn = !byn;

    switch (MODO) {
    case 0:
    case 1:
      h.beginDraw();
      h.clear();

      for (int i=0; i<h.width; i++) {
        color c = color(random(255), random(255), random(255));

        if (random(1) < 0.3) {
          if (byn) h.stroke(green(c));
          else h.stroke(c);
        }
        if (random(1) < 0.7) h.point(i, 0);

        wave[i] = map(red(c), 0, 255, -1, 1);
      }
      h.endDraw();

      break;
    case 2:
    case 3:
      v.beginDraw();
      v.clear();
      for (int i=0; i<v.height; i++) {
        color c = color(random(255), random(255), random(255));

        if (random(1) < 0.3) {
          if (byn) v.stroke(red(c));
          else v.stroke(c);
        }
        if (random(1) < 0.7) v.point(0, i);

        wave[i] = map(green(c), 0, 255, -1, 1);
      }
      v.endDraw();
      break;
    }
  }

  buffer.beginDraw();
  switch (MODO) {
  case 0:
    buffer.image(buffer.get(), 0, 1);
    buffer.stroke(0);
    buffer.image(h, 0, 0);
    break;
  case 1:
    buffer.image(buffer.get(), 0, -1);
    buffer.image(h, 0, buffer.height-1);
    break;
  case 2:
    buffer.image(buffer.get(), 1, 0);
    buffer.image(v, 0, 0);
    break;
  case 3:
    buffer.image(buffer.get(), -1, 0);
    buffer.image(v, buffer.width -1, 0);
    break;
  }

  buffer.endDraw();


  image(buffer, 0, 0, width, height);
  
  // debug
  //translate(0, height/2);
  //stroke(255);
  //strokeWeight(2);
  //float w = width/wave.length;
  //for (int i=0; i<wave.length-1; i++) {
  //  line(i*w, wave[i] * height/2, (i+1)*w, wave[i+1] * height/2);
  //}
  
}
