
%define COLOR_BG 19
%define VIDEO_BUFFER_HI 0a000h
%define VARS_BEGIN 400h
%define PARTS_BEGIN 500h
%define MODE_13 13h
%define PART_COUNT 400

%define fire_palette_size 8

%macro fire_palette 0
    db 0x00
    db 0xb9
    db 0x71
    db 0x29
    db 0x2a
    db 0x2b
    db 0x5b
    db 0x5c
%endmacro

%macro set_es_to 1
    push %1
    pop es
%endmacro

%macro switch_to_video_mode 1
    mov al,%1
    int 10h
%endmacro

%macro exit_on_escape_or_goto 1
    in al,60h
    dec al
    jnz %1
    int 20h
%endmacro

%macro clear_screen_with 1
    mov al, %1
    dec cx
    rep stosb
%endmacro

%macro wait_for_vsync 0
;   vsync
    mov dx, 0x03da
    mov cl, 0x08
.vsync_poll:
    in al,dx
    test al,cl
    jz .vsync_poll
%endmacro

struc vars
    .random_seed: resw 2
    .frame_counter: resw 2
    .sub_frame_counter: resw 2
endstruc

struc part
    .x: resw 1
    .sx: resw 1
    .y: resw 1
    .sy: resw 1
    .z: resw 1
    .sz: resw 1
    .w: resw 1
    .sw: resw 1
    .trail0: resw 1
    .trail1: resw 1
    .trail2: resw 1
    .trail3: resw 1
    .trail4: resw 1
    .trail5: resw 1
    .trail6: resw 1
    .trail7: resw 1
endstruc

%macro update_part_bx 0

    push cx

    mov di, [bx+part.trail7]
    mov byte [es:di], COLOR_BG

    mov si, bx
    add si, part.trail0
    mov dx, [si]
    mov cx,7

.propagate_trail:
    lodsw ;inc si by 2
    xchg dx, [si]
    loop .propagate_trail

    mov si, bx

    ; gravity
    mov ax, 5
    add [bx+part.sy], ax
    sub [bx+part.sw], ax

    mov cx,4
.process_coord_loop:
    update_part_coord_si
    loop .process_coord_loop
    ; part.w stays in ax
    push ax

    update_calc_pixel_address
    pop ax ; restore w
    sar ax, 13
    mov si, palette + fire_palette_size/2
    add si, ax
    mov di, [bx+part.trail0]
    movsb
    
    pop cx
    
%endmacro

%macro update_part_coord_si 0
    test bp, 1ffh
    jne .skip_reset

    generate_random_ax
    sar ax, 2
    mov dx, bp
    sal dh, 3
    or dh,  00001111b
    and dh, 00111111b
    imul dx
    mov ax, bp
    sal ax, cl
    jmp .store_speed_and_position

.skip_reset:
    mov dx, [si+part.sx]
    mov ax, 0x7fff
    cmp ax, [bx+part.y]
    jg .skip_ground_friction
    mov ax, 0x0800
.skip_ground_friction:
    imul dx
    mov ax, [si+part.x]
    add ax, dx
    jno .skip_bounce
    sub ax, dx
    neg dx
    sar dx,1
.store_speed_and_position:
    mov [si+part.sx], dx
.skip_bounce:
    mov [si+part.x], ax
    add si, 4
%endmacro

%macro update_calc_pixel_address 0
    push cx
    mov cx, [bx+part.z]
    sar cx, 8
    add cx, 480
    
    mov ax, [bx+part.y]
    cwd 
    idiv cx
    add ax, 100
    mov dx, 320
    mul dx
    push ax
    
    mov ax, [bx+part.x]
    cwd
    idiv cx
    pop dx
    add dx, 160
    add ax, dx
    mov [bx+part.trail0], ax
    pop cx
%endmacro


%macro generate_random_ax 0
    mov dx, [VARS_BEGIN + vars.random_seed]
    mov ax, 15083
    mul dx
    mov [VARS_BEGIN + vars.random_seed], ax
%endmacro