; How to achieve 210b ZX2 bytes in 256b intro?
; Here are step-by-step instructions:

; do it backward
; build packed data with "zx2off.exe -f -b -z -x -y -o KBA-KBA.bin KBA-KBA.bzxyo"
; align of source code start to #80xx to reuse for A
; align of packed data end to #xx00 to reuse of B
; remove EoF #FF in ZX2 data
; remove INC for all offsets in ZX2 data (zx2off.exe -o do it for you)
; no RET and no JUMP (self-destruct depacking)
; stack leaks a bit (no PUSH / POP BC) but it is not a problem for 256b
; no last ZX2 offset (second byte after #FF in the beginning of ZX2 data)

; So, here is the final proofed data both from KBA and KBA-KBA releases:
;
; 210 ZX2b = 46b on decompressor, backward, "zx2off.exe -f -b -z -x -y -o"
; 205 ZX2b = 51b on decompressor, forward , "zx2off.exe -f -z -x -y -o"
;
; SjASMplus home - https://github.com/z00m128/sjasmplus
; ZX2 home - https://github.com/einar-saukas/ZX2
;
; .ded, 09.09.2022

	DEVICE	ZXSPECTRUM48

	org	#7fe0		;32736

begin:	equ $

	ld	de,#8000+768
	ld	hl,finish-1	;!!! autosetup no need to correct
;	call	dzx2_nano_back

; --------------------------------------------------------------
; ZX2 decoder by Einar Saukas
; "Nano" version (48-55 bytes) - BACKWARDS VARIANT
; --------------------------------------------------------------
; Parameters:
;   HL: last source address (compressed data)
;   DE: last destination address (decompressing)
; --------------------------------------------------------------

dzx2_nano_back:

;IF DEFINED ZX2_Z_IGNORE_DEFAULT
;        ld      b, 0                    ; allocate default offset
	ld	b,e		;!! DE reuse
;ELSE
;        ld      bc, 1                   ; preserve default offset 1
;ENDIF

;!!        push    bc

;        ld      a, $80
	ld	a,h		;!! HL reuse

dzx2nb_literals:
        call    dzx2nb_elias            ; obtain length
        lddr                            ; copy literals
        add     a, a                    ; copy from last offset or new offset?
        jr      c, dzx2nb_new_offset
dzx2nb_reuse:
        call    dzx2nb_elias            ; obtain length
dzx2nb_copy:
        ex      (sp), hl                ; preserve source, restore offset
        push    hl                      ; preserve offset
        add     hl, de                  ; calculate destination - offset
        lddr                            ; copy from offset
        pop     hl                      ; restore offset
        ex      (sp), hl                ; preserve offset, restore source
        add     a, a                    ; copy from literals or new offset?
        jr      nc, dzx2nb_literals
dzx2nb_new_offset:
;!!        pop     bc                      ; discard last offset
        ld      c, (hl)                 ; obtain offset LSB
        dec     hl
;!!        inc     c			;useless coz offsets are not pre-decremented
;!!        ret     z                   ; check end marker
        push    bc                      ; preserve new offset

;IF DEFINED ZX2_X_SKIP_INCREMENT
        jr      dzx2nb_reuse
;ELSE
;        call    dzx2nb_elias            ; obtain length
;        inc     bc
;        jr      dzx2nb_copy
;ENDIF

dzx2nb_elias:
        ld      c, 1                    ; interlaced Elias gamma coding
dzx2nb_elias_loop:
        add     a, a
        jr      nz, dzx2nb_elias_skip
        ld      a, (hl)                 ; load another group of 8 bits
        dec     hl
        rla
dzx2nb_elias_skip:
        ret     nc
        add     a, a
        rl      c

;IF DEFINED ZX2_Y_LIMIT_LENGTH
;ELSE
;        rl      b
;ENDIF

        jr      dzx2nb_elias_loop
; --------------------------------------------------------------

packed:	incbin "KBA-KBA-unpacked.bzxyo",2 ;!! this include ZX2 file without first 2 bytes

finish:	
	SAVESNA	"KBA-KBA.sna", begin
	SAVEBIN	"2.bin", begin, finish-begin
	EMPTYTRD"KBA-KBA.trd","KBA-KBA"
	SAVETRD	"KBA-KBA.trd","2.C",begin,finish-begin
;-------=RMDA=---------------------------------------------[eof]