#version 330 core

layout(location = 0) in vec3 vertexPosition;
layout(location = 1) in vec2 vertexTexCoord;
layout(location = 2) in vec3 vertexNormal;
layout(location = 3) in vec4 vertexColor;

out vec2 texCoord;
out vec2 texCoordVs;
out vec2 texCoordStill;
out vec4 vertexFragColor;
uniform mat4 mvp;

uniform sampler2D texture1;
uniform sampler2D terrain;
uniform float time;

uniform float heightMagnitude = 40.0;
uniform float distanceMagnitude = 0.0;

uniform float zRotate = 0.0;
uniform float twistRotate = 0.0;

uniform float ySpace = 0.0;
uniform float xSpace = 0.04;
uniform float gridStep = 0.04;

uniform float timeMultiplier = 0.2;
out float xSpaceFrag;

uniform float zPosition = 0.0;
uniform float xPosition = 0.0;
uniform float yPosition = 0.0;
uniform float fade = 0.1;
uniform vec2 position = vec2(-0.5, -0.5);
uniform vec4 backgroundColor = vec4(0,0,0,0);
uniform float curveThickness = 0.6;
uniform float curveBendDegrees = 70;
uniform float curvesDegrees = 90;

mat3 rotateZ(float angleRad) {
    float c = cos(angleRad);
    float s = sin(angleRad);
    return mat3(
        vec3(c, -s, 0),
        vec3(s, c, 0),
        vec3(0, 0, 1)
    );
}

mat2 r2d(float angleRad) {
    float c = cos(angleRad);
    float s = sin(angleRad);
    return mat2(
         c, s,
        -s, c
    );
}


void main() {
    xSpaceFrag = xSpace;
    vec2 texcoord = vertexTexCoord;
    float dist = distance(texcoord, vec2(0.5,0.5));
    texcoord -=vec2(0.5,0.5);
    texcoord *= r2d(zRotate+dist*twistRotate);
    texcoord +=vec2(0.5,0.5);

    texCoordStill = texcoord;
    //texcoord.y = mod(texcoord.y - time * timeMultiplier, 1.0);
    //texcoord.y = mod(texcoord.y - 0.7, 1.0);
    texCoord = texcoord;
    texCoordVs = texcoord;


    float height = texture(terrain, texcoord).r * heightMagnitude + dist*distanceMagnitude;
    /*vec4 runwayColor = texture(texture1, texcoord.yx);
    if (runwayColor.a > 0.0) {
        height = 0.0;
    }*/

    vec2 coord=texCoord.xy;
    float x = coord.x;
    float y = coord.y;

    coord += position;
    /*float curveBendRad = radians(curveBendDegrees);
    float curvesRad = radians(curvesDegrees);
    float bend = curveBendRad*log(length(coord));
    float d = mod((time*2.5)+atan(coord.x,coord.y)+bend, curvesRad);
    if (d < curvesRad*curveThickness)
    {
        float cx = position.x+x;
        float cy = position.y+y;
        float circle = 1.0/sqrt(cx*cx + cy*cy);

        float d2 = 0;
        float size = 1.5-sqrt(cx*cx + cy*cy)*(10*sin(time*5.5));
        d2 = sin(sqrt(x*x)*80)*1.5*size+cos(sqrt(y*y)*80)*1.2*size;
        d += 0.15*d2;

        height *= d*0.6;
    }*/

    vec3 vert = vertexPosition;
    vert.z = height+zPosition;
    vert.x += xPosition;
    vert.y += yPosition;

    //vert -= vec3(vec2(100),0);
    //vert *= rotateZ(3.8);
    //vert += vec3(vec2(100),0);

    vertexFragColor = vec4(1);

    /*float centerLine= 0.5;
    float horizontalCenter = abs(vertexTexCoord.x - centerLine);
    if (abs(vertexTexCoord.x - centerLine) < xSpaceFrag || abs(vertexTexCoord.y - centerLine) < ySpace) {
        vert.z = 0;
    } else {
        //griddify
        float step = gridStep;
        float xc = mod(vertexTexCoord.x, step)/step;
        float yc = mod(vertexTexCoord.y, step)/step;
        float cc = 1.0-clamp(min(xc,yc)*100,0.0,1.0);

        vertexFragColor = vec4(vec3(cc),1);
    }*/

    gl_Position =  mvp * vec4(vert, 1);

    //if (vert.z > 0.0) {
    //}
}
