/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020\u0005H\u0002J\u0010\u00101\u001a\u00020,2\u0006\u00100\u001a\u00020\u0005H\u0016R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\n\"\u0004\b\u0019\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\n\"\u0004\b\u001e\u0010\fR\u0014\u0010\u001f\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0014R\u001a\u0010!\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\n\"\u0004\b#\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\nR\u001a\u0010%\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\n\"\u0004\b'\u0010\fR\u001a\u0010(\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\n\"\u0004\b*\u0010\f\u00a8\u00062"}, d2={"LCircleDrugDot;", "LMovingThing;", "img", "Ljava/awt/image/BufferedImage;", "speed", "", "angleSpeed", "(Ljava/awt/image/BufferedImage;DD)V", "angle", "getAngle", "()D", "setAngle", "(D)V", "angleSkew", "getAngleSkew", "setAngleSkew", "getAngleSpeed", "centerX", "", "getCenterX", "()I", "centerY", "getCenterY", "currentSpeed", "getCurrentSpeed", "setCurrentSpeed", "getImg", "()Ljava/awt/image/BufferedImage;", "lastStart", "getLastStart", "setLastStart", "maxLen", "getMaxLen", "pos", "getPos", "setPos", "getSpeed", "x", "getX", "setX", "y", "getY", "setY", "draw", "", "g", "Ljava/awt/Graphics2D;", "restart", "elapsed", "tick", "teletext-tools"})
public final class CircleDrugDot
implements MovingThing {
    @NotNull
    private final BufferedImage img;
    private final double speed;
    private final double angleSpeed;
    private double pos;
    private double angle;
    private double x;
    private double y;
    private double currentSpeed;
    private double lastStart;
    private double angleSkew;
    private final int centerX;
    private final int centerY;
    private final int maxLen;

    public CircleDrugDot(@NotNull BufferedImage img, double speed, double angleSpeed) {
        Intrinsics.checkNotNullParameter(img, "img");
        this.img = img;
        this.speed = speed;
        this.angleSpeed = angleSpeed;
        this.currentSpeed = this.speed;
        this.centerX = 52;
        this.centerY = 24;
        this.maxLen = 156;
        this.restart(0.0 - PlasmaKt.getSineRND().nextDouble(1.0));
    }

    public /* synthetic */ CircleDrugDot(BufferedImage bufferedImage, double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d2 = -2.1;
        }
        this(bufferedImage, d, d2);
    }

    @NotNull
    public final BufferedImage getImg() {
        return this.img;
    }

    public final double getSpeed() {
        return this.speed;
    }

    public final double getAngleSpeed() {
        return this.angleSpeed;
    }

    public final double getPos() {
        return this.pos;
    }

    public final void setPos(double d) {
        this.pos = d;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final void setAngle(double d) {
        this.angle = d;
    }

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getCurrentSpeed() {
        return this.currentSpeed;
    }

    public final void setCurrentSpeed(double d) {
        this.currentSpeed = d;
    }

    public final double getLastStart() {
        return this.lastStart;
    }

    public final void setLastStart(double d) {
        this.lastStart = d;
    }

    public final double getAngleSkew() {
        return this.angleSkew;
    }

    public final void setAngleSkew(double d) {
        this.angleSkew = d;
    }

    public final int getCenterX() {
        return this.centerX;
    }

    public final int getCenterY() {
        return this.centerY;
    }

    public final int getMaxLen() {
        return this.maxLen;
    }

    private final void restart(double elapsed) {
        this.pos = 0.0;
        this.angle = PlasmaKt.getSineRND().nextDouble(Math.PI * 2);
        this.currentSpeed = this.speed * PlasmaKt.getSineRND().nextDouble(1.2, 1.3);
        this.lastStart = elapsed;
        this.x = 0.0;
        this.y = 0.0;
        this.angleSkew = PlasmaKt.getSineRND().nextDouble(-0.5, 0.5);
    }

    @Override
    public void tick(double elapsed) {
        double dotElapsed = elapsed - this.lastStart;
        this.pos = dotElapsed * this.currentSpeed;
        if (this.pos > 1.0) {
            this.restart(elapsed);
        }
        double useAngleSpeed = Math.sin(1.1 * elapsed + this.pos * 3.0) * this.angleSpeed;
        double useAngle = this.angle + useAngleSpeed;
        this.x = (double)this.centerX + Math.sin(useAngle + this.angleSkew * dotElapsed) * this.pos * (double)this.maxLen;
        this.y = (double)this.centerY + Math.cos(useAngle + this.angleSkew * dotElapsed) * this.pos * (double)this.maxLen;
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        double sizeW = GlobalsKt.lerp(this.pos, 28.0, (double)this.img.getWidth() * 1.0);
        double sizeH = sizeW * 0.7;
        double drawX = this.x - sizeW / 2.0;
        double drawY = this.y - sizeH / 2.0;
        g.drawImage(this.img, MathKt.roundToInt(drawX), MathKt.roundToInt(drawY), MathKt.roundToInt(sizeW), MathKt.roundToInt(sizeH), null);
    }
}

