/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.sound.sampled.Clip;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u00162\u0006\u0010@\u001a\u000208H\u0002J\b\u0010A\u001a\u00020<H\u0016J\u0018\u0010B\u001a\u00020<2\u0006\u0010C\u001a\u00020\u00162\u0006\u0010D\u001a\u000208H\u0016J\u0010\u0010E\u001a\u00020<2\u0006\u0010D\u001a\u000208H\u0002J\u0018\u0010F\u001a\u00020<2\u0006\u0010G\u001a\u00020\u00162\u0006\u0010@\u001a\u000208H\u0002J\f\u0010H\u001a\b\u0012\u0004\u0012\u00020$0IJ\u0006\u0010J\u001a\u00020<J\u0006\u0010K\u001a\u00020<J\u0010\u0010L\u001a\u00020<2\u0006\u0010M\u001a\u00020\u0016H\u0002J'\u0010N\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010@\u001a\u0002082\b\u0010O\u001a\u0004\u0018\u000108H\u0002\u00a2\u0006\u0002\u0010PJ\u0006\u0010Q\u001a\u00020<R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0013\u0010)\u001a\u0004\u0018\u00010*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001c\u00101\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010,\"\u0004\b3\u00104R\u0011\u00105\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010(R\u0014\u00107\u001a\u000208X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:\u00a8\u0006R"}, d2={"LDemoScript;", "LEffect;", "audio", "LAudioOutput;", "insertTimeStampTopLeft", "", "(LAudioOutput;Z)V", "getAudio", "()LAudioOutput;", "clipStart", "", "getClipStart", "()Ljava/lang/Long;", "setClipStart", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "currentEffect", "getCurrentEffect", "()LEffect;", "setCurrentEffect", "(LEffect;)V", "currentEffectIndex", "", "getCurrentEffectIndex", "()Ljava/lang/Integer;", "setCurrentEffectIndex", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "dumpStream", "Ljava/io/OutputStream;", "getDumpStream", "()Ljava/io/OutputStream;", "setDumpStream", "(Ljava/io/OutputStream;)V", "events", "", "LDemoEvent;", "getEvents", "()Ljava/util/List;", "getInsertTimeStampTopLeft", "()Z", "music", "Ljavax/sound/sampled/Clip;", "getMusic", "()Ljavax/sound/sampled/Clip;", "page", "LTeletextPage;", "getPage", "()LTeletextPage;", "playingClip", "getPlayingClip", "setPlayingClip", "(Ljavax/sound/sampled/Clip;)V", "probablyOnRaspi", "getProbablyOnRaspi", "runInTime", "", "getRunInTime", "()D", "doInsertTimestamp", "", "buf", "", "y", "elapsed", "doReset", "doTick", "ticks", "elapsedWithRunIn", "drawCountDown", "ensureCurrentEffect", "index", "getDemoEvents", "", "goBack", "goForward", "goto", "newIndex", "insertTimestamp", "effectElapsed", "([BDLjava/lang/Double;)V", "keyPressed", "teletext-tools"})
public final class DemoScript
extends Effect {
    @Nullable
    private final AudioOutput audio;
    private final boolean insertTimeStampTopLeft;
    @Nullable
    private Integer currentEffectIndex;
    @Nullable
    private Effect currentEffect;
    @NotNull
    private final TeletextPage page;
    private final double runInTime;
    @Nullable
    private final Clip music;
    @NotNull
    private final List<DemoEvent> events;
    @Nullable
    private Clip playingClip;
    private final boolean probablyOnRaspi;
    @Nullable
    private Long clipStart;
    @Nullable
    private OutputStream dumpStream;

    public DemoScript(@Nullable AudioOutput audio, boolean insertTimeStampTopLeft) {
        super("DEMO");
        this.audio = audio;
        this.insertTimeStampTopLeft = insertTimeStampTopLeft;
        this.page = new TeletextPage(null, 1, null);
        this.runInTime = 4.0;
        AudioOutput audioOutput = this.audio;
        this.music = audioOutput != null ? audioOutput.prepareClip("sfx/bigbeat.wav") : null;
        this.events = new ArrayList();
        String string = System.getProperty("os.name");
        this.probablyOnRaspi = string != null ? StringsKt.contains$default((CharSequence)string, "Linux", false, 2, null) : false;
    }

    @Nullable
    public final AudioOutput getAudio() {
        return this.audio;
    }

    public final boolean getInsertTimeStampTopLeft() {
        return this.insertTimeStampTopLeft;
    }

    @Nullable
    public final Integer getCurrentEffectIndex() {
        return this.currentEffectIndex;
    }

    public final void setCurrentEffectIndex(@Nullable Integer n) {
        this.currentEffectIndex = n;
    }

    @Nullable
    public final Effect getCurrentEffect() {
        return this.currentEffect;
    }

    public final void setCurrentEffect(@Nullable Effect effect) {
        this.currentEffect = effect;
    }

    @NotNull
    public final TeletextPage getPage() {
        return this.page;
    }

    public final double getRunInTime() {
        return this.runInTime;
    }

    @Nullable
    public final Clip getMusic() {
        return this.music;
    }

    @NotNull
    public final List<DemoEvent> getEvents() {
        return this.events;
    }

    @Nullable
    public final Clip getPlayingClip() {
        return this.playingClip;
    }

    public final void setPlayingClip(@Nullable Clip clip) {
        this.playingClip = clip;
    }

    public final boolean getProbablyOnRaspi() {
        return this.probablyOnRaspi;
    }

    @Nullable
    public final Long getClipStart() {
        return this.clipStart;
    }

    public final void setClipStart(@Nullable Long l) {
        this.clipStart = l;
    }

    @Nullable
    public final OutputStream getDumpStream() {
        return this.dumpStream;
    }

    public final void setDumpStream(@Nullable OutputStream outputStream) {
        this.dumpStream = outputStream;
    }

    @Override
    public void doReset() {
        this.currentEffect = null;
        this.currentEffectIndex = null;
        this.events.clear();
        this.events.addAll((Collection<DemoEvent>)this.getDemoEvents());
        Clip clip = this.playingClip;
        if (clip != null) {
            clip.stop();
        }
        this.playingClip = null;
        this.clipStart = null;
        this.dumpStream = new FileOutputStream("420years.t42");
    }

    @NotNull
    public final List<DemoEvent> getDemoEvents() {
        List ret = new ArrayList();
        ((Collection)ret).add(new DemoEvent(0, 0, 0, 1, null, 16, null));
        ((Collection)ret).add(new DemoEvent(0, 21, 836, 2, null, 16, null));
        ((Collection)ret).add(new DemoEvent(0, 36, 300, 3, null, 16, null));
        ((Collection)ret).add(new DemoEvent(1, 15, 0, 1, null, 16, null));
        return ret;
    }

    @Override
    public void doTick(int ticks, double elapsedWithRunIn) {
        double elapsed = 0.0;
        Clip clip = this.playingClip;
        if (clip != null) {
            if (this.probablyOnRaspi) {
                long start;
                Long l = this.clipStart;
                long l2 = start = l != null ? l : System.currentTimeMillis();
                if (this.clipStart == null) {
                    this.clipStart = start;
                }
                elapsed = (double)(System.currentTimeMillis() - start) / 1000.0;
            } else {
                elapsed = (double)clip.getMicrosecondPosition() / 1000000.0;
            }
        } else {
            elapsed = elapsedWithRunIn - this.runInTime;
        }
        boolean started = false;
        if (elapsed < 0.0) {
            this.drawCountDown(elapsed);
        } else {
            started = true;
            int n = this.events.size() - 1;
            for (int i = 0; i < n; ++i) {
                double nextStart = this.events.get(i + 1).getTime();
                if (!(elapsed < nextStart)) continue;
                DemoEvent event = this.events.get(i);
                this.ensureCurrentEffect(event.getEffectIndex(), elapsed);
                Function2<Double, Effect, Unit> function2 = event.getHandler();
                if (function2 == null) break;
                function2.invoke(elapsed, this.currentEffect);
                break;
            }
        }
        Effect effect = this.currentEffect;
        Clip clip2 = this.playingClip;
        if (!(clip2 != null ? !clip2.isRunning() : false)) {
            Effect effect2 = effect;
            if (effect2 != null) {
                effect2.tick(elapsed);
            }
        }
        if (effect != null) {
            this.setBuf(effect.getBuf());
        } else {
            this.setBuf(BuffersAndEncodingKt.formatAsPage$default(this.page.getData(), 256, null, 4, null));
        }
        if (started) {
            OutputStream outputStream = this.dumpStream;
            if (outputStream != null) {
                OutputStream out = outputStream;
                boolean bl = false;
                out.write(this.getBuf());
                out.flush();
            }
        }
        if (this.insertTimeStampTopLeft) {
            Effect effect3 = this.currentEffect;
            this.insertTimestamp(this.getBuf(), elapsed, effect3 != null ? effect3.getLastElapsed() : null);
        }
    }

    private final void ensureCurrentEffect(int index, double elapsed) {
        block4: {
            Integer n = this.currentEffectIndex;
            int n2 = index;
            if (n != null && n == n2) {
                return;
            }
            this.currentEffectIndex = index;
            if (this.currentEffect == null && this.playingClip == null) {
                Clip clip = this.music;
                if (clip != null) {
                    clip.setMicrosecondPosition(0L);
                }
                Clip clip2 = this.music;
                if (clip2 != null) {
                    clip2.start();
                }
                this.playingClip = this.music;
            }
            this.currentEffect = MainKt.getAllEffects().get(index);
            Effect effect = this.currentEffect;
            System.out.println((Object)("\nnew effect: " + index + " = " + (effect != null ? effect.getName() : null) + " @ " + elapsed));
            Effect effect2 = this.currentEffect;
            if (effect2 == null) break block4;
            effect2.reset(elapsed);
        }
    }

    public final void goBack() {
        Integer n = this.currentEffectIndex;
        if (n == null) {
            return;
        }
        int index = n;
        this.goto(index - 1);
    }

    public final void goForward() {
        Integer n = this.currentEffectIndex;
        if (n == null) {
            return;
        }
        int index = n;
        this.goto(index + 1);
    }

    /*
     * WARNING - void declaration
     */
    private final void goto(int newIndex) {
        void $this$filterTo$iv$iv;
        System.out.println((Object)("\ngoto " + newIndex));
        Iterable $this$filter$iv = this.events;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DemoEvent it = (DemoEvent)element$iv$iv;
            boolean bl = false;
            if (!(it.getEffectIndex() == newIndex)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        DemoEvent demoEvent = (DemoEvent)CollectionsKt.firstOrNull((List)destination$iv$iv);
        if (demoEvent != null) {
            DemoEvent event = demoEvent;
            boolean bl = false;
            long micros = (long)(event.getTime() * 1000000.0);
            this.currentEffect = null;
            Clip clip = this.playingClip;
            if (clip != null) {
                clip.setMicrosecondPosition(micros);
            }
            this.ensureCurrentEffect(newIndex, event.getTime());
            return;
        }
        System.out.println((Object)("goto: effect " + newIndex + " not found"));
    }

    private final void insertTimestamp(byte[] buf, double elapsed, Double effectElapsed) {
        block0: {
            this.doInsertTimestamp(buf, 0, elapsed);
            Double d = effectElapsed;
            if (d == null) break block0;
            double it = ((Number)d).doubleValue();
            boolean bl = false;
            this.doInsertTimestamp(buf, 1, it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doInsertTimestamp(byte[] buf, int y, double elapsed) {
        boolean neg = elapsed < 0.0;
        int totalMillis = (int)(Math.abs(elapsed) * 1000.0);
        int totalSecs = totalMillis / 1000;
        int millis = totalMillis % 1000;
        int secs = totalSecs % 60;
        int mins = totalSecs / 60;
        String string = "\u001c\u0007%s%d:%02d.%02d";
        Object[] objectArray = new Object[]{neg ? "-" : "", mins, secs, millis / 10};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
        String formatted = string2;
        CharSequence $this$forEachIndexed$iv = formatted;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void c;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c2 = item$iv;
            int index = n;
            boolean bl = false;
            buf[42 * y + 42 - formatted.length() + index] = (byte)BuffersAndEncodingKt.parity((int)c);
        }
    }

    private final void drawCountDown(double elapsedWithRunIn) {
        this.page.fill(32);
        int count = (int)Math.abs(elapsedWithRunIn);
        int ch = count > 0 ? 48 + count : 32;
        this.page.set(20, 12, ch);
    }

    public final void keyPressed() {
        Clip clip = this.playingClip;
        if (clip == null) {
            return;
        }
        long micros = clip.getMicrosecondPosition();
        long totalMillis = micros / 1000L;
        long totalSecs = totalMillis / (long)1000;
        long millis = totalMillis % (long)1000;
        long secs = totalSecs % (long)60;
        long mins = totalSecs / (long)60;
        String string = "        ret += DemoEvent(%d,%2d,%3d,    %d) /*             * EVENT */";
        Object[] objectArray = new Object[4];
        objectArray[0] = mins;
        objectArray[1] = secs;
        objectArray[2] = millis / (long)10;
        Integer n = this.currentEffectIndex;
        objectArray[3] = n != null ? n : -1;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
        string = string2;
        System.out.println((Object)string);
    }
}

