/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u0014H\u0014R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"LImagePanel;", "Ljavax/swing/JPanel;", "image", "Ljava/awt/image/BufferedImage;", "scale", "", "(Ljava/awt/image/BufferedImage;I)V", "g", "Ljava/awt/Graphics2D;", "getImage", "()Ljava/awt/image/BufferedImage;", "setImage", "(Ljava/awt/image/BufferedImage;)V", "getScale", "()I", "getImageGraphics", "getPreferredSize", "Ljava/awt/Dimension;", "paintComponent", "", "Ljava/awt/Graphics;", "teletext-tools"})
public class ImagePanel
extends JPanel {
    @NotNull
    private BufferedImage image;
    private final int scale;
    @Nullable
    private Graphics2D g;

    public ImagePanel(@NotNull BufferedImage image, int scale) {
        Intrinsics.checkNotNullParameter(image, "image");
        this.image = image;
        this.scale = scale;
    }

    public /* synthetic */ ImagePanel(BufferedImage bufferedImage, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(bufferedImage, n);
    }

    @NotNull
    public final BufferedImage getImage() {
        return this.image;
    }

    public final void setImage(@NotNull BufferedImage bufferedImage) {
        Intrinsics.checkNotNullParameter(bufferedImage, "<set-?>");
        this.image = bufferedImage;
    }

    public final int getScale() {
        return this.scale;
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter(g, "g");
        super.paintComponent(g);
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int offX = this.getBorder() != null ? this.getBorder().getBorderInsets((Component)((Component)this)).left - this.getBorder().getBorderInsets((Component)((Component)this)).right : 0;
        int offY = this.getBorder() != null ? this.getBorder().getBorderInsets((Component)((Component)this)).top - this.getBorder().getBorderInsets((Component)((Component)this)).bottom : 0;
        int drawW = this.image.getWidth() * this.scale;
        int drawH = this.image.getHeight() * this.scale;
        drawW = RangesKt.coerceIn(drawW, RangesKt.until(0, this.getWidth()));
        drawH = RangesKt.coerceIn(drawH, RangesKt.until(0, this.getHeight()));
        int x = (this.getWidth() - drawW) / 2 + offX / 2;
        int y = (this.getHeight() - drawH) / 2 + offY / 2;
        g.drawImage(this.image, x, y, drawW, drawH, null);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        return new Dimension(this.image.getWidth() * this.scale + ((object4 = this.getBorder()) != null && (object4 = object4.getBorderInsets(this)) != null ? ((Insets)object4).left : 0) + ((object3 = this.getBorder()) != null && (object3 = object3.getBorderInsets(this)) != null ? ((Insets)object3).right : 0), this.image.getHeight() * this.scale + ((object2 = this.getBorder()) != null && (object2 = object2.getBorderInsets(this)) != null ? ((Insets)object2).top : 0) + ((object = this.getBorder()) != null && (object = object.getBorderInsets(this)) != null ? ((Insets)object).bottom : 0));
    }

    @NotNull
    public final Graphics2D getImageGraphics() {
        if (this.g == null) {
            this.g = this.image.createGraphics();
        }
        Graphics2D graphics2D = this.g;
        Intrinsics.checkNotNull(graphics2D);
        return graphics2D;
    }
}

