/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.OutputStream;
import java.net.Socket;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!J\b\u0010#\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0010\"\u0004\b\u0019\u0010\u001aR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"LNetworkConnection;", "LBufRenderer;", "ip", "", "port", "", "status", "Ljavax/swing/JLabel;", "(Ljava/lang/String;ILjavax/swing/JLabel;)V", "getIp", "()Ljava/lang/String;", "out", "Ljava/io/OutputStream;", "getOut", "()Ljava/io/OutputStream;", "getPort", "()I", "socket", "Ljava/net/Socket;", "getSocket", "()Ljava/net/Socket;", "spinnerChars", "getSpinnerChars", "spinnerPos", "getSpinnerPos", "setSpinnerPos", "(I)V", "getStatus", "()Ljavax/swing/JLabel;", "disconnect", "", "render", "buf", "", "send", "toString", "teletext-tools"})
public final class NetworkConnection
implements BufRenderer {
    @NotNull
    private final String ip;
    private final int port;
    @Nullable
    private final JLabel status;
    @NotNull
    private final Socket socket;
    @NotNull
    private final OutputStream out;
    private int spinnerPos;
    @NotNull
    private final String spinnerChars;

    public NetworkConnection(@NotNull String ip, int port, @Nullable JLabel status) {
        Intrinsics.checkNotNullParameter(ip, "ip");
        this.ip = ip;
        this.port = port;
        this.status = status;
        this.spinnerChars = "/-\\-";
        JLabel jLabel = this.status;
        if (jLabel != null) {
            jLabel.setText("connecting to " + this.ip + ':' + this.port);
        }
        JLabel jLabel2 = this.status;
        if (jLabel2 != null) {
            jLabel2.setForeground(null);
        }
        this.socket = new Socket(this.ip, this.port);
        OutputStream outputStream = this.socket.getOutputStream();
        Intrinsics.checkNotNullExpressionValue(outputStream, "socket.getOutputStream()");
        this.out = outputStream;
        JLabel jLabel3 = this.status;
        if (jLabel3 != null) {
            jLabel3.setText("connected to " + this.ip + ':' + this.port);
        }
        JLabel jLabel4 = this.status;
        if (jLabel4 != null) {
            jLabel4.setForeground(new Color(32768));
        }
    }

    @NotNull
    public final String getIp() {
        return this.ip;
    }

    public final int getPort() {
        return this.port;
    }

    @Nullable
    public final JLabel getStatus() {
        return this.status;
    }

    @NotNull
    public final Socket getSocket() {
        return this.socket;
    }

    @NotNull
    public final OutputStream getOut() {
        return this.out;
    }

    public final int getSpinnerPos() {
        return this.spinnerPos;
    }

    public final void setSpinnerPos(int n) {
        this.spinnerPos = n;
    }

    @NotNull
    public final String getSpinnerChars() {
        return this.spinnerChars;
    }

    @Override
    public void render(@NotNull byte[] buf) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        this.send(buf);
    }

    public final void send(@NotNull byte[] buf) {
        block7: {
            Intrinsics.checkNotNullParameter(buf, "buf");
            boolean raw = buf.length % 42 == 0;
            byte[] sendBuf = null;
            sendBuf = raw ? buf : BuffersAndEncodingKt.formatAsPage$default(buf, 256, null, 4, null);
            try {
                this.out.write(sendBuf);
                this.out.flush();
                JLabel jLabel = this.status;
                if (jLabel != null) {
                    jLabel.setText("OK sent: " + sendBuf.length + " [" + this.spinnerChars.charAt(this.spinnerPos) + ']');
                }
                for (int x = 8; x < 40; ++x) {
                    MainKt.getFillingHeader()[x] = buf[x];
                }
                PageHeaderControlBit[] x = new PageHeaderControlBit[]{PageHeaderControlBit.C7_SUPPRESS_HEADER};
                BuffersAndEncodingKt.insertPageHeader(MainKt.getFillingHeader(), 0, 511, 0, x);
                this.out.write(MainKt.getFillingHeader());
                this.out.flush();
                JLabel jLabel2 = this.status;
                if (jLabel2 != null) {
                    jLabel2.setText("OK sent: " + sendBuf.length + " [" + this.spinnerChars.charAt(this.spinnerPos) + "] " + MainKt.getFillingHeader().length);
                }
                this.spinnerPos = (this.spinnerPos + 1) % this.spinnerChars.length();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.status == null) {
                    throw new IllegalStateException("network is gone", e);
                }
                JLabel jLabel = this.status;
                if (jLabel != null) {
                    jLabel.setText("send error (" + e.getClass().getSimpleName() + ' ' + e.getMessage() + ')');
                }
                JLabel jLabel3 = this.status;
                if (jLabel3 == null) break block7;
                jLabel3.setForeground(new Color(0x800000));
            }
        }
    }

    public final void disconnect() {
        block4: {
            try {
                this.out.close();
                JLabel jLabel = this.status;
                if (jLabel != null) {
                    jLabel.setText("closed");
                }
                JLabel jLabel2 = this.status;
                if (jLabel2 != null) {
                    jLabel2.setForeground(null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JLabel jLabel = this.status;
                if (jLabel == null) break block4;
                jLabel.setText("close error (" + e.getClass().getSimpleName() + ' ' + e.getMessage() + ')');
            }
        }
    }

    @NotNull
    public String toString() {
        return this.ip + ':' + this.port;
    }
}

