/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J(\u0010\u0017\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u001e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\u001e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u0003J\u0016\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003J\u0016\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003J\u0016\u0010*\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003J\u001e\u0010+\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010,\u001a\u00020&J\u001e\u0010+\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003J\u000e\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u0006J\b\u0010/\u001a\u00020\"H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u00060"}, d2={"LTeletextArea;", "", "w", "", "h", "data", "", "(II[B)V", "getData", "()[B", "getH", "()I", "getW", "applyClippingFadeToBlack", "", "fade", "", "protected", "", "LPointXY;", "applyClippingFadeToWhite", "applyFadeToBlack", "applyFadeToWhite", "copyRect", "srcX", "srcY", "drawSprite", "other", "dstX", "dstY", "drawString", "x", "y", "s", "", "fill", "ch", "get", "", "replace", "from", "to", "replaceInline", "set", "value", "takeDataFrom", "buf", "toString", "teletext-tools"})
public class TeletextArea {
    private final int w;
    private final int h;
    @NotNull
    private final byte[] data;

    public TeletextArea(int w, int h, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter(data, "data");
        this.w = w;
        this.h = h;
        this.data = data;
        if (!(this.data.length == this.w * this.h)) {
            boolean bl = false;
            String string = "data has invalid size (expected: " + this.w + " * " + this.h + " = " + this.w * this.h + ", actual: " + this.data.length;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ TeletextArea(int n, int n2, byte[] byArray, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            int n4 = 0;
            int n5 = n * n2;
            byte[] byArray2 = new byte[n5];
            while (n4 < n5) {
                int n6 = n4++;
                byArray2[n6] = 32;
            }
            byArray = byArray2;
        }
        this(n, n2, byArray);
    }

    public final int getW() {
        return this.w;
    }

    public final int getH() {
        return this.h;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    public final byte get(int x, int y) {
        if (!(x >= 0 && y >= 0 && x < this.w && y < this.h)) {
            boolean bl = false;
            String string = "get(" + x + ',' + y + "): out of bounds (" + this.w + '*' + this.h + ')';
            throw new IllegalArgumentException(string.toString());
        }
        return (byte)(this.data[y * this.w + x] & 0x7F);
    }

    public final void set(int x, int y, byte value) {
        if (!(x >= 0 && y >= 0 && x < this.w && y < this.h)) {
            boolean bl = false;
            String string = "set(" + x + ',' + y + ',' + value + "): out of bounds (" + this.w + '*' + this.h + ')';
            throw new IllegalArgumentException(string.toString());
        }
        this.data[y * this.w + x] = value;
    }

    public final void set(int x, int y, int value) {
        this.set(x, y, (byte)value);
    }

    @Nullable
    public final TeletextArea copyRect(int srcX, int srcY, int w, int h) {
        TeletextArea area = new TeletextArea(w, h, null, 4, null);
        if (!(srcX >= 0 && srcY >= 0 && srcX + w - 1 < this.w && srcY + h - 1 < this.h)) {
            boolean $i$a$-require-TeletextArea$copyRect$22 = false;
            String $i$a$-require-TeletextArea$copyRect$22 = "sub-area " + srcX + ',' + srcY + ".." + (srcX + w - 1) + ',' + (srcY + h - 1) + " is out of bounds (" + this + ')';
            throw new IllegalArgumentException($i$a$-require-TeletextArea$copyRect$22.toString());
        }
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                area.set(x, y, this.get(srcX + x, srcY + y));
            }
        }
        return area;
    }

    @NotNull
    public String toString() {
        return "TeletextArea(" + this.w + '*' + this.h + ')';
    }

    public final void drawSprite(@NotNull TeletextArea other, int dstX, int dstY) {
        Intrinsics.checkNotNullParameter(other, "other");
        int drawY = dstY;
        int n = other.h;
        for (int y = 0; y < n; ++y) {
            boolean bl = 0 <= drawY ? drawY < this.h : false;
            if (bl) {
                int drawX = dstX;
                int n2 = other.w;
                for (int x = 0; x < n2; ++x) {
                    boolean bl2 = 0 <= drawX ? drawX < this.w : false;
                    if (bl2) {
                        this.set(drawX, drawY, other.get(x, y));
                    }
                    ++drawX;
                }
            }
            ++drawY;
        }
    }

    @NotNull
    public final TeletextArea replace(int from, int to) {
        byte[] newData = (byte[])this.data.clone();
        Iterable $this$forEach$iv = ArraysKt.getIndices(newData);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            if ((byte)(newData[it] & 0x7F) != (byte)from) continue;
            newData[it] = (byte)to;
        }
        return new TeletextArea(this.w, this.h, newData);
    }

    public final void replaceInline(int from, int to) {
        Iterable $this$forEach$iv = ArraysKt.getIndices(this.data);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            if ((byte)(this.data[it] & 0x7F) != (byte)from) continue;
            this.data[it] = (byte)to;
        }
    }

    public final void takeDataFrom(@NotNull byte[] buf) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        if (!(buf.length >= this.data.length)) {
            boolean $i$a$-require-TeletextArea$takeDataFrom$22 = false;
            String $i$a$-require-TeletextArea$takeDataFrom$22 = "source buffer (" + buf.length + ") needs to be >= " + this.data.length;
            throw new IllegalArgumentException($i$a$-require-TeletextArea$takeDataFrom$22.toString());
        }
        byte[] $this$forEachIndexed$iv = this.data;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (byte item$iv : $this$forEachIndexed$iv) {
            int n = index$iv++;
            byte by = item$iv;
            int index = n;
            boolean bl = false;
            this.data[index] = buf[index];
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void drawString(int x, int y, @NotNull String s) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(s, "s");
        Iterable $this$filter$iv = StringsKt.getIndices(s);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(x + it < this.w)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            this.set(x + it, y, (byte)s.charAt(it));
        }
    }

    public final void applyFadeToBlack(double fade) {
        int n = this.h;
        for (int y = 0; y < n; ++y) {
            int n2 = this.w;
            for (int x = 0; x < n2; ++x) {
                byte by = this.get(x, y);
                if (!BuffersAndEncodingKt.isColorSetter(by)) continue;
                int col = by & 7;
                int gfxBit = by & 0x10;
                int brightness = GlobalsKt.getCOLORS_SORTED_BY_BRIGHTNESS().indexOf((Object)TeletextColor.values()[col]);
                int fadedBrightness = RangesKt.coerceAtMost((int)((double)brightness * fade), GlobalsKt.getCOLORS_SORTED_BY_BRIGHTNESS().size() - 1);
                TeletextColor newColor = GlobalsKt.getCOLORS_SORTED_BY_BRIGHTNESS().get(fadedBrightness);
                byte newByte = (byte)(newColor.ordinal() | gfxBit);
                this.set(x, y, newByte);
            }
        }
    }

    public final void applyFadeToWhite(double fade) {
        int n = this.h;
        for (int y = 0; y < n; ++y) {
            int n2 = this.w;
            for (int x = 0; x < n2; ++x) {
                byte by = this.get(x, y);
                if (!BuffersAndEncodingKt.isColorSetter(by)) continue;
                int col = by & 7;
                int gfxBit = by & 0x10;
                int brightness = GlobalsKt.getCOLORS_SORTED_BY_BRIGHTNESS().indexOf((Object)TeletextColor.values()[col]);
                int newColorIndex = (int)GlobalsKt.lerp(fade, brightness, GlobalsKt.getCOLORS_SORTED_BY_BRIGHTNESS().size() - 1);
                if (newColorIndex < 0) {
                    newColorIndex = 0;
                }
                if (newColorIndex > GlobalsKt.getCOLORS_SORTED_BY_BRIGHTNESS().size() - 1) {
                    newColorIndex = GlobalsKt.getCOLORS_SORTED_BY_BRIGHTNESS().size() - 1;
                }
                TeletextColor newColor = GlobalsKt.getCOLORS_SORTED_BY_BRIGHTNESS().get(newColorIndex);
                byte newByte = (byte)(newColor.ordinal() | gfxBit);
                this.set(x, y, newByte);
            }
        }
    }

    public final void applyClippingFadeToWhite(double fade) {
        int n = this.h;
        for (int y = 0; y < n; ++y) {
            int n2 = this.w;
            for (int x = 0; x < n2; ++x) {
                byte by = this.get(x, y);
                if (!BuffersAndEncodingKt.isColorSetter(by)) continue;
                int col = by & 7;
                int gfxBit = by & 0x10;
                int brightness = GlobalsKt.getCOLORS_SORTED_BY_BRIGHTNESS().indexOf((Object)TeletextColor.values()[col]);
                int maxBrightness = RangesKt.coerceIn(MathKt.roundToInt((double)(GlobalsKt.getCOLORS_SORTED_BY_BRIGHTNESS().size() - 1) * fade), 0, GlobalsKt.getCOLORS_SORTED_BY_BRIGHTNESS().size() - 1);
                int newBrightness = Math.max(brightness, maxBrightness);
                TeletextColor newColor = GlobalsKt.getCOLORS_SORTED_BY_BRIGHTNESS().get(newBrightness);
                byte newByte = (byte)(newColor.ordinal() | gfxBit);
                this.set(x, y, newByte);
            }
        }
    }

    public final void applyClippingFadeToBlack(double fade, @Nullable List<PointXY> list) {
        int n = this.h;
        for (int y = 0; y < n; ++y) {
            int n2 = this.w;
            for (int x = 0; x < n2; ++x) {
                byte by;
                List<PointXY> list2 = list;
                if ((list2 != null ? list2.contains(new PointXY(x, y)) : false) || !BuffersAndEncodingKt.isColorSetter(by = this.get(x, y))) continue;
                int col = by & 7;
                int gfxBit = by & 0x10;
                int brightness = GlobalsKt.getCOLORS_SORTED_BY_BRIGHTNESS().indexOf((Object)TeletextColor.values()[col]);
                int fadedBrightness = (int)((double)brightness * fade);
                if (fadedBrightness < 0) {
                    fadedBrightness = 0;
                }
                TeletextColor newColor = GlobalsKt.getCOLORS_SORTED_BY_BRIGHTNESS().get(Math.min(brightness, fadedBrightness));
                byte newByte = (byte)(newColor.ordinal() | gfxBit);
                this.set(x, y, newByte);
            }
        }
    }

    public static /* synthetic */ void applyClippingFadeToBlack$default(TeletextArea teletextArea, double d, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: applyClippingFadeToBlack");
        }
        if ((n & 2) != 0) {
            list = null;
        }
        teletextArea.applyClippingFadeToBlack(d, list);
    }

    public final void fill(int ch) {
        int n = this.h;
        for (int y = 0; y < n; ++y) {
            int n2 = this.w;
            for (int x = 0; x < n2; ++x) {
                this.set(x, y, ch);
            }
        }
    }
}

