/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"LTeletextPage;", "LTeletextArea;", "data", "", "([B)V", "getLineStates", "", "LTeletextState;", "y", "", "Companion", "teletext-tools"})
public final class TeletextPage
extends TeletextArea {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public TeletextPage(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter(data, "data");
        super(40, 24, data);
    }

    public /* synthetic */ TeletextPage(byte[] byArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            int n2 = 0;
            byte[] byArray2 = new byte[960];
            while (n2 < 960) {
                int n3 = n2++;
                byArray2[n3] = 32;
            }
            byArray = byArray2;
        }
        this(byArray);
    }

    @NotNull
    public final List<TeletextState> getLineStates(int y) {
        int color = 7;
        boolean splitGraphics = false;
        List ret = new ArrayList();
        int n = this.getW();
        for (int x = 0; x < n; ++x) {
            switch (this.getData()[y * this.getW() + x] & 0x7F) {
                case 0: 
                case 16: {
                    color = 0;
                    break;
                }
                case 1: 
                case 17: {
                    color = 1;
                    break;
                }
                case 2: 
                case 18: {
                    color = 2;
                    break;
                }
                case 3: 
                case 19: {
                    color = 3;
                    break;
                }
                case 4: 
                case 20: {
                    color = 4;
                    break;
                }
                case 5: 
                case 21: {
                    color = 5;
                    break;
                }
                case 6: 
                case 22: {
                    color = 6;
                    break;
                }
                case 7: 
                case 23: {
                    color = 7;
                    break;
                }
                case 25: {
                    splitGraphics = false;
                    break;
                }
                case 26: {
                    splitGraphics = true;
                }
            }
            ((Collection)ret).add(new TeletextState(color, splitGraphics));
        }
        return ret;
    }

    public TeletextPage() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"LTeletextPage$Companion;", "", "()V", "read", "LTeletextPage;", "file", "Ljava/io/File;", "filename", "", "teletext-tools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TeletextPage read(@NotNull String filename) {
            Intrinsics.checkNotNullParameter(filename, "filename");
            return this.read(new File(filename));
        }

        @NotNull
        public final TeletextPage read(@NotNull File file) {
            Intrinsics.checkNotNullParameter(file, "file");
            if (!((int)file.length() >= 960)) {
                boolean bl = false;
                String string = file + " is too small (expected: 960, actual: " + file.length();
                throw new IllegalArgumentException(string.toString());
            }
            byte[] byArray = Arrays.copyOf(FilesKt.readBytes(file), 960);
            Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(this, newSize)");
            return new TeletextPage(byArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

