/*
 * Decompiled with CFR 0.152.
 */
import com.github.sarxos.webcam.Webcam;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010)\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0006\u00100\u001a\u00020$R\"\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u00061"}, d2={"LWebcamEffect;", "LEffect;", "()V", "g", "Ljava/awt/Graphics2D;", "kotlin.jvm.PlatformType", "getG", "()Ljava/awt/Graphics2D;", "setG", "(Ljava/awt/Graphics2D;)V", "g2", "getG2", "setG2", "img", "Ljava/awt/image/BufferedImage;", "getImg", "()Ljava/awt/image/BufferedImage;", "img2", "getImg2", "page", "LTeletextPage;", "getPage", "()LTeletextPage;", "setPage", "(LTeletextPage;)V", "preview", "LImagePanel;", "getPreview", "()LImagePanel;", "previewFrame", "Ljavax/swing/JFrame;", "getPreviewFrame", "()Ljavax/swing/JFrame;", "setPreviewFrame", "(Ljavax/swing/JFrame;)V", "webcam", "Lcom/github/sarxos/webcam/Webcam;", "getWebcam", "()Lcom/github/sarxos/webcam/Webcam;", "setWebcam", "(Lcom/github/sarxos/webcam/Webcam;)V", "doReset", "", "doTick", "ticks", "", "elapsed", "", "ensureWebcam", "teletext-tools"})
public final class WebcamEffect
extends Effect {
    @NotNull
    private TeletextPage page = new TeletextPage(null, 1, null);
    @Nullable
    private Webcam webcam;
    @NotNull
    private final BufferedImage img = new BufferedImage(80, 72, 1);
    @NotNull
    private final BufferedImage img2 = new BufferedImage(80, 72, 1);
    private Graphics2D g = this.img.createGraphics();
    private Graphics2D g2 = this.img2.createGraphics();
    @NotNull
    private final ImagePanel preview = new ImagePanel(this.img2, 4);
    @Nullable
    private JFrame previewFrame;

    public WebcamEffect() {
        super("Webcam");
    }

    @NotNull
    public final TeletextPage getPage() {
        return this.page;
    }

    public final void setPage(@NotNull TeletextPage teletextPage) {
        Intrinsics.checkNotNullParameter(teletextPage, "<set-?>");
        this.page = teletextPage;
    }

    @Nullable
    public final Webcam getWebcam() {
        return this.webcam;
    }

    public final void setWebcam(@Nullable Webcam webcam) {
        this.webcam = webcam;
    }

    @NotNull
    public final BufferedImage getImg() {
        return this.img;
    }

    @NotNull
    public final BufferedImage getImg2() {
        return this.img2;
    }

    public final Graphics2D getG() {
        return this.g;
    }

    public final void setG(Graphics2D graphics2D) {
        this.g = graphics2D;
    }

    public final Graphics2D getG2() {
        return this.g2;
    }

    public final void setG2(Graphics2D graphics2D) {
        this.g2 = graphics2D;
    }

    @NotNull
    public final ImagePanel getPreview() {
        return this.preview;
    }

    @Nullable
    public final JFrame getPreviewFrame() {
        return this.previewFrame;
    }

    public final void setPreviewFrame(@Nullable JFrame jFrame) {
        this.previewFrame = jFrame;
    }

    @Override
    public void doReset() {
        if (this.previewFrame == null) {
            this.previewFrame = FontAndRenderingKt.showInFrame$default("webcam", this.preview, false, 4, null);
        }
    }

    @Override
    public void doTick(int ticks, double elapsed) {
        Webcam cam = this.ensureWebcam();
        BufferedImage capture = cam.getImage();
        this.g.drawImage(capture, 0, 0, this.img.getWidth(), this.img.getHeight(), null);
        this.g2.drawImage(capture, 0, 0, this.img.getWidth(), this.img.getHeight(), null);
        this.preview.repaint();
        BufferedImage dith = DitherKt.dither(this.img, true);
        byte[] convBuf = ImageUtilsKt.convertImage$default(dith, 0, 0, 0, null, true, 30, null);
        this.page.takeDataFrom(convBuf);
        this.page.set(8, 0, 23);
        BuffersAndEncodingKt.formatAsPage(this.page.getData(), 256, this.getBuf());
    }

    @NotNull
    public final Webcam ensureWebcam() {
        Webcam webcam = this.webcam;
        if (webcam != null) {
            Webcam it = webcam;
            boolean bl = false;
            return it;
        }
        Webcam newcam = Webcam.getDefault();
        newcam.setViewSize(new Dimension(320, 240));
        newcam.open();
        this.webcam = newcam;
        Intrinsics.checkNotNullExpressionValue(newcam, "newcam");
        return newcam;
    }
}

