/*
 * Decompiled with CFR 0.152.
 */
package parti;

import parti.NewSPH;
import parti.Particle;

public class Neighbor {
    Particle p1 = null;
    Particle p2 = null;
    double distance = 0.0;
    double nx = 0.0;
    double ny = 0.0;
    double weight = 0.0;

    void setParticle(Particle p1, Particle p2) {
        this.p1 = p1;
        this.p2 = p2;
        this.nx = p1.x - p2.x;
        this.ny = p1.y - p2.y;
        this.distance = Math.sqrt(this.nx * this.nx + this.ny * this.ny);
        this.weight = 1.0 - this.distance / NewSPH.range;
        double temp = this.weight * this.weight * this.weight;
        p1.density += temp;
        p2.density += temp;
        temp = 1.0 / this.distance;
        this.nx *= temp;
        this.ny *= temp;
    }

    void calcForce() {
        double pressureWeight = this.weight * (this.p1.pressure + this.p2.pressure) / (this.p1.density + this.p2.density) * NewSPH.pressure;
        double viscosityWeight = this.weight / (this.p1.density + this.p2.density) * NewSPH.viscosity;
        this.p1.fx += this.nx * pressureWeight;
        this.p1.fy += this.ny * pressureWeight;
        this.p2.fx -= this.nx * pressureWeight;
        this.p2.fy -= this.ny * pressureWeight;
        double rvx = this.p2.vx - this.p1.vx;
        double rvy = this.p2.vy - this.p1.vy;
        this.p1.fx += rvx * viscosityWeight;
        this.p1.fy += rvy * viscosityWeight;
        this.p2.fx -= rvx * viscosityWeight;
        this.p2.fy -= rvy * viscosityWeight;
    }
}

