/*
 * Decompiled with CFR 0.152.
 */
package parti;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import parti.GridCell;
import parti.Neighbor;
import parti.Particle;

public class NewSPH
extends JPanel {
    static double gravity = 0.6;
    public static double range = 10.0;
    static double pressure = 2.0;
    static double viscosity = 0.07;
    double range2 = range * range;
    int particleSize = 6;
    double density = 1.0;
    int numGrids = 40;
    static int screenSize = 600;
    double invGridSize = 1 / (screenSize / this.numGrids);
    int numLiquidParticles = 250;
    int numSolidParticles = 50;
    int numParticles = this.numLiquidParticles + this.numSolidParticles;
    Particle[] particles = new Particle[this.numParticles];
    ArrayList<Neighbor> neighbors = new ArrayList();
    int numNeighbors = 0;
    int count = 0;
    GridCell[][] grids = new GridCell[this.numGrids][this.numGrids];
    static int drawW = 78;
    static int drawH = 72;
    BufferedImage renderImage = new BufferedImage(drawW, drawH, 1);
    Graphics2D g = this.renderImage.createGraphics();

    public NewSPH(boolean startTimer) {
        for (int i = 0; i < this.numGrids; ++i) {
            for (int j = 0; j < this.numGrids; ++j) {
                this.grids[i][j] = new GridCell();
            }
        }
        this.initParticles();
    }

    public void move() {
        ++this.count;
        this.updateGrids();
        this.findNeighbors();
        this.calcPressure();
        this.calcForce();
        for (int i = 0; i < this.particles.length; ++i) {
            Particle p = this.particles[i];
            p.move();
        }
    }

    void updateGrids() {
        int i;
        for (i = 0; i < this.numGrids; ++i) {
            for (int j = 0; j < this.numGrids; ++j) {
                this.grids[i][j].clear();
            }
        }
        for (i = 0; i < this.particles.length; ++i) {
            Particle p = this.particles[i];
            p.density = 0.0;
            p.fy = 0.0;
            p.fx = 0.0;
            p.gx = (int)Math.floor(p.x * this.invGridSize);
            p.gy = (int)Math.floor(p.y * this.invGridSize);
            if (p.gx < 0) {
                p.gx = 0;
            }
            if (p.gy < 0) {
                p.gy = 0;
            }
            if (p.gx > this.numGrids - 1) {
                p.gx = this.numGrids - 1;
            }
            if (p.gy > this.numGrids - 1) {
                p.gy = this.numGrids - 1;
            }
            this.grids[p.gx][p.gy].add(p);
        }
    }

    void findNeighbors() {
        this.numNeighbors = 0;
        for (int i = 0; i < this.particles.length; ++i) {
            Particle p = this.particles[i];
            boolean xMin = p.gx != 0;
            boolean xMax = p.gx != this.numGrids - 1;
            boolean yMin = p.gy != 0;
            boolean yMax = p.gy != this.numGrids - 1;
            this.findNeighborsInGrid(p, this.grids[p.gx][p.gy]);
            if (xMin) {
                this.findNeighborsInGrid(p, this.grids[p.gx - 1][p.gy]);
            }
            if (xMax) {
                this.findNeighborsInGrid(p, this.grids[p.gx + 1][p.gy]);
            }
            if (yMin) {
                this.findNeighborsInGrid(p, this.grids[p.gx][p.gy - 1]);
            }
            if (yMax) {
                this.findNeighborsInGrid(p, this.grids[p.gx][p.gy + 1]);
            }
            if (xMin && yMin) {
                this.findNeighborsInGrid(p, this.grids[p.gx - 1][p.gy - 1]);
            }
            if (xMin && yMax) {
                this.findNeighborsInGrid(p, this.grids[p.gx - 1][p.gy + 1]);
            }
            if (xMax && yMin) {
                this.findNeighborsInGrid(p, this.grids[p.gx + 1][p.gy - 1]);
            }
            if (!xMax || !yMax) continue;
            this.findNeighborsInGrid(p, this.grids[p.gx + 1][p.gy + 1]);
        }
    }

    void findNeighborsInGrid(Particle pi, GridCell cell) {
        for (int j = 0; j < cell.particleList.size(); ++j) {
            double distance;
            Particle pj = cell.particleList.get(j);
            if (pi.equals(pj) || !((distance = (pi.x - pj.x) * (pi.x - pj.x) + (pi.y - pj.y) * (pi.y - pj.y)) < this.range2)) continue;
            if (this.neighbors.size() == this.numNeighbors) {
                this.neighbors.add(new Neighbor());
            }
            this.neighbors.get(this.numNeighbors++).setParticle(pi, pj);
        }
    }

    void calcPressure() {
        for (int i = 0; i < this.particles.length; ++i) {
            Particle p = this.particles[i];
            if (p.density < this.density) {
                p.density = this.density;
            }
            p.pressure = p.density - this.density;
        }
    }

    void calcForce() {
        for (int i = 0; i < this.numNeighbors; ++i) {
            Neighbor n = this.neighbors.get(i);
            n.calcForce();
        }
    }

    void initParticles() {
        ArrayList<Particle> newParticles = new ArrayList<Particle>();
        try {
            BufferedImage img = ImageIO.read(new File("gfx/in-flow.png"));
            for (int y = 0; y < img.getHeight(); y += 3) {
                for (int x = 0; x < img.getWidth(); x += 2) {
                    int col = img.getRGB(x, y);
                    if ((col & 0xFF00) != 0) continue;
                    newParticles.add(new Particle((double)(x * 3) + Math.random() * 1.0, (double)(90 + y * 3) + Math.random() * 1.0));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.particles = newParticles.toArray(new Particle[newParticles.size()]);
    }

    public BufferedImage renderImage() {
        this.g.setColor(Color.WHITE);
        this.g.fillRect(0, 0, drawW, drawH);
        this.g.setColor(Color.BLACK);
        for (int i = 0; i < this.particles.length; ++i) {
            Particle p = this.particles[i];
            int x = (int)(p.x * 1.0 / (double)screenSize * (double)drawW);
            int y = (int)(p.y * 1.0 / (double)screenSize * (double)drawW) - 9;
            this.g.fillOval(x - 1, y - 1, (int)Math.round(2.5 + Math.random() * 1.5), (int)Math.round(2.5 + Math.random() * 1.5));
        }
        return this.renderImage;
    }

    @Override
    public void paint(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.renderImage(), 10, 10, null);
    }

    int clamp(int p) {
        if (p > 255) {
            return 255;
        }
        if (p < 0) {
            return 0;
        }
        return p;
    }
}

