/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.data.FloatSample;
import com.jsyn.data.SequentialData;
import com.jsyn.unitgen.VariableRateDataReader;
import com.jsyn.unitgen.VariableRateMonoReader;
import com.jsyn.unitgen.VariableRateStereoReader;
import processing.core.PApplet;
import processing.sound.Engine;
import processing.sound.JSynCircuit;
import processing.sound.SoundObject;

public class AudioSample
extends SoundObject {
    protected FloatSample sample;
    protected VariableRateDataReader player;
    protected int startFrame = 0;
    protected long startFrameCountOffset = 0L;
    private long isPlayingAtLeastUntil = 0L;

    public AudioSample(PApplet pApplet, int n) {
        this(pApplet, n, false);
    }

    public AudioSample(PApplet pApplet, int n, boolean bl) {
        this(pApplet, n, bl, 44100);
    }

    public AudioSample(PApplet pApplet, int n, boolean bl, int n2) {
        super(pApplet);
        this.sample = new FloatSample(n, bl ? 2 : 1);
        this.sample.setFrameRate((double)n2);
        this.initiatePlayer();
    }

    public AudioSample(PApplet pApplet, int n, int n2) {
        this(pApplet, n, false, n2);
    }

    public AudioSample(PApplet pApplet, float[] fArray) {
        this(pApplet, fArray, false);
    }

    public AudioSample(PApplet pApplet, float[] fArray, boolean bl) {
        this(pApplet, fArray, bl, 44100);
    }

    public AudioSample(PApplet pApplet, float[] fArray, int n) {
        this(pApplet, fArray, false, n);
    }

    public AudioSample(PApplet pApplet, float[] fArray, boolean bl, int n) {
        super(pApplet);
        this.sample = new FloatSample(fArray, bl ? 2 : 1);
        this.sample.setFrameRate((double)n);
        this.initiatePlayer();
    }

    protected AudioSample(PApplet pApplet) {
        super(pApplet);
    }

    protected AudioSample(AudioSample audioSample) {
        super(null);
        this.sample = audioSample.sample;
        this.initiatePlayer();
        this.player.amplitude.set(audioSample.player.amplitude.get());
        this.player.rate.set(audioSample.player.rate.get());
        this.startFrame = audioSample.startFrame;
    }

    protected void initiatePlayer() {
        this.player = this.channels() == 2 ? new VariableRateStereoReader() : new VariableRateMonoReader();
        this.player.rate.set((double)this.sampleRate());
        this.circuit = new JSynCircuit(this.player.output);
        this.amplitude = this.player.amplitude;
        super.play();
        this.isPlaying = false;
    }

    @Override
    public boolean isPlaying() {
        if (this.isPlaying) {
            this.isPlaying = this.player.dataQueue.hasMore() || System.currentTimeMillis() < this.isPlayingAtLeastUntil;
        }
        return this.isPlaying;
    }

    @Override
    public void amp(float f) {
        if (Engine.checkAmp(f)) {
            this.player.amplitude.set((double)f);
        }
    }

    public int channels() {
        return this.sample.getChannelsPerFrame();
    }

    public void cue(float f) {
        if (this.setStartTime(f)) {
            this.stop();
            this.setStartFrameCountOffset();
        }
    }

    public void cueFrame(int n) {
        if (this.setStartFrame(n)) {
            this.stop();
            this.setStartFrameCountOffset();
        }
    }

    public float duration() {
        return (float)((double)this.frames() / this.sample.getFrameRate());
    }

    public int frames() {
        return this.sample.getNumFrames();
    }

    public void resize(int n) {
        this.resize(n, false);
    }

    private boolean setStartFrame(int n) {
        if (this.checkStartFrame(n)) {
            this.startFrame = n;
            return true;
        }
        return false;
    }

    private boolean setStartTime(float f) {
        if (f < 0.0f) {
            Engine.printError("absolute position can't be < 0");
            return false;
        }
        int n = Math.round((float)this.sampleRate() * f);
        if (n >= this.frames()) {
            Engine.printError("can't cue past end of sample (total duration is " + this.duration() + "s)");
            return false;
        }
        this.startFrame = n;
        return true;
    }

    public void jump(float f) {
        if (this.setStartTime(f)) {
            this.player.dataQueue.clear();
            this.playInternal();
        }
    }

    public void jumpFrame(int n) {
        if (this.setStartFrame(n)) {
            this.stop();
            this.play();
        }
    }

    protected AudioSample getUnusedPlayer() {
        if (this.isPlaying()) {
            return new AudioSample(this);
        }
        return this;
    }

    private void setStartFrameCountOffset() {
        this.startFrameCountOffset = this.player.dataQueue.getFrameCount();
    }

    private void loopInternal(int n, int n2, int n3) {
        this.stop();
        this.setStartFrameCountOffset();
        this.startFrame = n;
        if (n3 > 1) {
            this.player.dataQueue.queueLoop((SequentialData)this.sample, n, n2, n3);
        } else {
            this.player.dataQueue.queueLoop((SequentialData)this.sample, n, n2);
        }
        this.isPlayingAtLeastUntil = System.currentTimeMillis() + 50L;
        this.isPlaying = true;
    }

    private void loopInternal(int n, int n2) {
        this.loopInternal(n, n2, 0);
    }

    public void loop() {
        this.loopInternal(0, this.frames());
    }

    public void loop(float f) {
        this.rate(f);
        this.loop();
    }

    public void loop(float f, float f2) {
        this.rate(f);
        this.amp(f2);
        this.loop();
    }

    public void loop(float f, float f2, float f3) {
        this.pan(f2);
        this.loop(f, f3);
    }

    public void loop(float f, float f2, float f3, float f4) {
        this.add(f4);
        this.loop(f, f2, f3);
    }

    private void playInternal() {
        this.playInternal(this.startFrame, this.frames() - this.startFrame);
    }

    private void playInternal(int n, int n2) {
        this.setStartFrameCountOffset();
        this.player.dataQueue.queue((SequentialData)this.sample, n, n2);
        this.isPlayingAtLeastUntil = System.currentTimeMillis() + 50L;
        this.isPlaying = true;
    }

    @Override
    public void play() {
        AudioSample audioSample = this.getUnusedPlayer();
        audioSample.playInternal();
    }

    public void play(float f) {
        this.rate(f);
        this.play();
    }

    public void play(float f, float f2) {
        this.amp(f2);
        this.play(f);
    }

    public void play(float f, float f2, float f3) {
        this.pan(f2);
        this.play(f, f3);
    }

    public void play(float f, float f2, float f3, float f4) {
        this.add(f4);
        this.play(f, f2, f3);
    }

    public void play(float f, float f2, float f3, float f4, float f5) {
        this.cue(f5);
        this.play(f, f2, f3, f4);
    }

    public void playFor(float f) {
        AudioSample audioSample = this.getUnusedPlayer();
        audioSample.playInternal(this.startFrame, Math.min(Math.round(f * (float)this.sampleRate()), this.frames() - this.startFrame));
    }

    public void playFor(float f, float f2) {
        this.cue(f2);
        this.playFor(f);
    }

    public void rate(float f) {
        if (f <= 0.0f) {
            Engine.printError("rate needs to be positive");
        } else {
            this.player.rate.set((double)((float)this.sampleRate() * f));
        }
    }

    public void resize(int n, boolean bl) {
        this.stop();
        this.sample.allocate(n, bl ? 2 : 1);
        this.initiatePlayer();
    }

    public int sampleRate() {
        return (int)Math.round(this.sample.getFrameRate());
    }

    @Override
    public void pan(float f) {
        super.pan(f);
    }

    public void set(float f, float f2, float f3, float f4) {
        this.rate(f);
        this.pan(f2);
        this.amp(f3);
        this.add(f4);
    }

    @Override
    public void stop() {
        this.player.dataQueue.clear();
        this.isPlaying = false;
    }

    public float position() {
        return (float)this.positionFrame() / (float)this.sampleRate();
    }

    public int positionFrame() {
        return (int)((long)this.startFrame + this.player.dataQueue.getFrameCount() - this.startFrameCountOffset) % this.frames();
    }

    public float percent() {
        return 100.0f * (float)this.positionFrame() / (float)this.frames();
    }

    public void pause() {
        if (this.isPlaying()) {
            this.stop();
            this.startFrame = this.positionFrame();
            this.setStartFrameCountOffset();
        } else {
            Engine.printWarning("trying to pause an audio sample that is not playing");
        }
    }

    protected boolean checkStartFrame(int n) {
        return this.checkStartFrame(n, true);
    }

    protected boolean checkStartFrame(int n, boolean bl) {
        if (n < 0 || n >= this.frames()) {
            if (bl) {
                Engine.printError(Integer.toString(n) + " is not a valid start frame number (has to be in [0," + Integer.toString(this.frames() - 1) + "]");
            }
            return false;
        }
        return true;
    }

    public void read(float[] fArray) {
        if (this.channels() == 2 && fArray.length != 2 * this.frames()) {
            Engine.printWarning("the length of the array passed to read(float[]) does not match the size of the data of this stereo audio sample (note that stereo samples contain two values per frame!)");
        } else if (this.channels() == 1 && fArray.length != this.frames()) {
            Engine.printWarning("the length of the array passed to read(float[]) does not match the number of frames of this audio sample");
        }
        this.sample.read(fArray);
    }

    public void read(int n, float[] fArray, int n2, int n3) {
        if (this.checkStartFrame(n)) {
            if (n + n3 < this.frames()) {
                this.sample.read(n, fArray, n2, n3);
            } else {
                int n4 = this.frames() - n;
                this.sample.read(n, fArray, n2, n4);
                this.sample.read(0, fArray, n2 + n4, n3 - n4);
            }
        }
    }

    public float read(int n) {
        return (float)this.sample.readDouble(n);
    }

    public float read(int n, int n2) {
        if (n2 < 0 || n2 >= this.channels()) {
            Engine.printWarning("trying to read() from audiosample channel #" + n2 + " which does not exist, returning left channel value instead");
            n2 = 0;
        }
        return this.read(n * this.channels() + n2);
    }

    public void write(float[] fArray) {
        if (this.channels() == 2 && fArray.length != 2 * this.frames()) {
            Engine.printWarning("the length of the array passed to write(float[]) does not match the size of the data of this stereo audio sample (note that stereo samples contain two values per frame!)");
        } else if (this.channels() == 1 && fArray.length != this.frames()) {
            Engine.printWarning("the length of the array passed to write(float[]) does not match the number of frames of this audio sample");
        }
        this.sample.write(fArray);
    }

    public void write(int n, float[] fArray, int n2, int n3) {
        if (this.checkStartFrame(n)) {
            if (n + n3 < this.frames()) {
                this.sample.write(n, fArray, n2, n3);
            } else {
                int n4 = this.frames() - n;
                this.sample.write(n, fArray, n2, n4);
                this.sample.write(0, fArray, n2 + n4, n3 - n4);
            }
        }
    }

    public void write(int n, float f) {
        if (this.channels() == 2) {
            Engine.printWarning("write(int, float) only writes data to the left channel of a stereo file, please use one of the other write() methods to write data to all channels");
        }
        if (this.checkStartFrame(this.startFrame)) {
            this.sample.writeDouble(n, (double)f);
        }
    }
}

