/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.apps;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.devices.javasound.MidiDeviceTools;
import com.jsyn.instruments.JSynInstrumentLibrary;
import com.jsyn.midi.MessageParser;
import com.jsyn.swing.InstrumentBrowser;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.swing.PresetSelectionListener;
import com.jsyn.swing.SoundTweaker;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.UnitSource;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.PolyphonicInstrument;
import com.jsyn.util.VoiceDescription;
import com.softsynth.math.AudioMath;
import com.softsynth.shared.time.TimeStamp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.swing.JApplet;

public class InstrumentTester
extends JApplet {
    private static final long serialVersionUID = -2704222221111608377L;
    private Synthesizer synth;
    private LineOut lineOut;
    private SoundTweaker tweaker;
    protected PolyphonicInstrument instrument;
    private MyParser messageParser;

    public int setupMidiKeyboard() throws MidiUnavailableException, IOException, InterruptedException {
        this.messageParser = new MyParser();
        int n = 2;
        MidiDevice midiDevice = MidiDeviceTools.findKeyboard();
        CustomReceiver customReceiver = new CustomReceiver();
        if (midiDevice != null) {
            midiDevice.open();
            midiDevice.getTransmitter().setReceiver(customReceiver);
            System.out.println("Play MIDI keyboard: " + midiDevice.getDeviceInfo().getDescription());
            n = 0;
        } else {
            System.out.println("Could not find a keyboard.");
        }
        return n;
    }

    @Override
    public void init() {
        this.setLayout(new BorderLayout());
        this.synth = JSyn.createSynthesizer();
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        InstrumentBrowser instrumentBrowser = new InstrumentBrowser(new JSynInstrumentLibrary());
        instrumentBrowser.addPresetSelectionListener(new PresetSelectionListener(){

            @Override
            public void presetSelected(VoiceDescription voiceDescription, int n) {
                UnitVoice[] unitVoiceArray = new UnitVoice[8];
                for (int i = 0; i < unitVoiceArray.length; ++i) {
                    unitVoiceArray[i] = voiceDescription.createUnitVoice();
                }
                InstrumentTester.this.instrument = new PolyphonicInstrument(unitVoiceArray);
                InstrumentTester.this.synth.add(InstrumentTester.this.instrument);
                InstrumentTester.this.instrument.usePreset(n, InstrumentTester.this.synth.createTimeStamp());
                String string = voiceDescription.getVoiceClassName() + ": " + voiceDescription.getPresetNames()[n];
                InstrumentTester.this.useSource(InstrumentTester.this.instrument, string);
            }
        });
        this.add((Component)instrumentBrowser, "North");
        try {
            this.setupMidiKeyboard();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.validate();
    }

    private void useSource(UnitSource unitSource, String string) {
        this.lineOut.input.disconnectAll(0);
        this.lineOut.input.disconnectAll(1);
        unitSource.getOutput().connect(0, this.lineOut.input, 0);
        unitSource.getOutput().connect(0, this.lineOut.input, 1);
        if (this.tweaker != null) {
            this.remove(this.tweaker);
        }
        try {
            if (this.synth.isRunning()) {
                this.synth.sleepFor(0.1);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.tweaker = new SoundTweaker(this.synth, string, unitSource);
        this.add((Component)this.tweaker, "Center");
        this.validate();
    }

    @Override
    public void start() {
        this.synth.start();
        this.lineOut.start();
    }

    @Override
    public void stop() {
        this.synth.stop();
    }

    public static void main(String[] stringArray) {
        InstrumentTester instrumentTester = new InstrumentTester();
        JAppletFrame jAppletFrame = new JAppletFrame("InstrumentTester", instrumentTester);
        jAppletFrame.setSize(600, 800);
        jAppletFrame.setVisible(true);
        jAppletFrame.test();
    }

    class CustomReceiver
    implements Receiver {
        CustomReceiver() {
        }

        @Override
        public void close() {
            System.out.print("Closed.");
        }

        @Override
        public void send(MidiMessage midiMessage, long l) {
            byte[] byArray = midiMessage.getMessage();
            InstrumentTester.this.messageParser.parse(byArray);
        }
    }

    class MyParser
    extends MessageParser {
        MyParser() {
        }

        @Override
        public void controlChange(int n, int n2, int n3) {
        }

        @Override
        public void noteOff(int n, int n2, int n3) {
            InstrumentTester.this.instrument.noteOff(n2, InstrumentTester.this.synth.createTimeStamp());
        }

        @Override
        public void noteOn(int n, int n2, int n3) {
            double d = AudioMath.pitchToFrequency(n2);
            double d2 = (double)n3 / 512.0;
            TimeStamp timeStamp = InstrumentTester.this.synth.createTimeStamp();
            InstrumentTester.this.instrument.noteOn(n2, d, d2, timeStamp);
        }
    }
}

