/*
 * Paraguay collor correction pipe by rimina
 */

THREE.ParaguayColorCorrect = {

	uniforms: {
		"tDiffuse": { type: "t", value: null },
		"gamma": {type: "v3", value: new THREE.Vector3(2.2, 2.2, 2.2)},
		"fade" : {type: "f", value: 0},
		"fadeColor" : {type: "v3", value: new THREE.Vector3(0, 0, 0)},
	},

	vertexShader: [

		"varying vec2 vUv;",
		"void main() {",
			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",
		"}"

	].join("\n"),

	fragmentShader: [

        "uniform sampler2D tDiffuse;",
        "uniform vec3 gamma;",
        "uniform float fade;",
		"uniform vec3 fadeColor;",

        "varying vec2 vUv;",

        "void main() {",
            "vec4 c = texture2D( tDiffuse, vUv );",
            //fade
			"c.rgb = mix(c.rgb, fadeColor, smoothstep(0.0, 1.0, fade));",

            "float vigentOffset = 0.4;",
            "float darkness = 0.6;",
            "float dist = distance( vUv, vec2( 0.5 ) );",
            "c.rgb *= smoothstep( 0.8, vigentOffset * 0.799, dist *( darkness + vigentOffset ) );",

            //"c.rbg = pow(c.rbg, 1.0/abs(gamma));",

            "gl_FragColor = c;",
        "}"

	].join("\n")

};
