; encoding of source: ISO-8859-1
;
; "FEFE OUT 4B" - ZX Spectrum four byte intro ... or more like "outro"... with a bit of 1 bit bytebeat
;
; In Memory of Pavuk //\\oo//\\, first 7 Gods member operating in other dimensions.
;
; Ped / 7 Gods, http://7gods.org/, https://www.pouet.net/groups.php?which=113
; (C) 2022 Peter Helcmanovsky, license: MIT
;
; assembler used: https://github.com/z00m128/sjasmplus
;

    DEVICE ZXSPECTRUM48
    ORG $FEFE
code_start:
    otir
    jr code_start
code_end equ $

CODE        EQU     $AF
USR         EQU     $C0
LOAD        EQU     $EF
CLEAR       EQU     $FD
RANDOMIZE   EQU     $F9

    ;; produce TAP file with the intro
        DEFINE tape_file "7g_fefe_out_4b.tap"
        DEFINE prog_name "FEFE 4B"   ;  is $DF (token OUT)

        ;; 10 CLEAR 3e4:LOAD "FEFE 4B"CODE
        ;; 20 RANDOMIZE USR 65278
        ORG     $5C00
tap_bas:
        DB      0,10    ;; Line number 10
        DW      .l10ln  ;; Line length
.l10:   DB      CLEAR,'3e4',$0E,0,0
        DW      30000
        DB      0,':'
        DB      LOAD,'"'
.fname: DB      prog_name
        ASSERT  ($ - .fname) <= 10
        DB      '"',CODE,$0D
.l10ln: EQU     $-.l10
        DB      0,20    ;; Line number 20
        DW      .l20ln
.l20:   DB      RANDOMIZE,USR,"65278",$0E,0,0
        DW      code_start
        DB      0,$0D
.l20ln: EQU     $-.l20
.l:     EQU     $-tap_bas

        EMPTYTAP tape_file
        SAVETAP  tape_file,BASIC,prog_name,tap_bas,tap_bas.l,1
        SAVETAP  tape_file,CODE,prog_name,code_start,code_end-code_start,code_start
