; etato2, a 64byte intro by gopher/alcatraz for Lovebyte 2022
; looks best above 250000 cycles (DosBox)
; thanks to all the gurus at the sizecoding discord for tips/tricks/templates
org 100h                       
start:		
	mov		al,13h	
	int		10h	
	les		cx,[bx]			; es: ~0xA000
mainloop:
	movsx	ax,ch
	sub		[si],ah			; "zoom" at the cost of not perfect rotation
	sub		[si-1],ax		; [si-1]: sin -= cos*a 
	movsx	ax,byte[si]
	add		cx,ax			; cx    : cos += sin*a
pixelloop:
	mov		ax,0xcccd
	mul		di
	; screen subdivision
	xor		dx,0xc0c0	
	;x = dl as signed byte
	;y = dh as signed byte
	;x' = dl*ch - dh*[si]
	;y' = dh*ch	+ dl*[si]							
	inc		bx
scloop:	
	mov		[bx],bp			; [0] = x'
	neg		dh				; dl = x, dh = -y	
	mov		al,dl			; al = x	
	imul	ch				; ax = x*cos	
	xchg	bp,ax			; bx = x*cos
	mov		al,dh			; al = -y
	imul	byte[si]		; ax = -y*sin
	add		bp,ax			; bx = x' = x*cos - y*sin	
	; prepare for second run, flip x and y
	xchg	dl,dh			; dl = -y, dh = x	
	dec		bx
	jz 		scloop
	inc		bx
	; xor output and color range
	xor		bp,[bx]
	xchg	ax,bp
	and		ah,0x4d
output:	
	mov		[es:di],ah		; output pixel
	inc		di				; next pixel
	jnz		pixelloop		; loop pixels
	jmp		mainloop		; loop frames