; pestis 27b:
; - reuse pixel color as line width
; - By "chance", les bp, [bx] gives very good segment!
; - do 65536 loops every time (slow, but works)
org 100h
    mov     al, 0x13            ; Setup video mode
    int     0x10
    les     bp, [bx]            ; Video segment (slightly shifted)
M:  mov     ax, 0xCCCD + 0x105  ; On first round, skew Rrrola trick to left
    mov     bl, 31              ; Pixelcolor = 31 (white)
L:  mul     di                  ; Rrrola trick
    cmp     dl, bl              ; If (skewed) x is less than line width
    jb      S                   ; ...then jump to setting white pixel
    mov     ax, 0xCCCD - 0x105  ; On following round(s), skew right
    loop    L
    inc     bx                  ; Increase pixelcolor to 32 = blue
S:  xchg    bx, ax
    stosb                       ; Put pixel on screen
    jmp     M
