; pestis 33b:
; - two skewed Rrrola tricks make a cross in the scottish flag
; - default palette: 1 = blue, 15 = white

org 100h
    mov     al, 0x13            ; Setup video mode
    int     0x10
    push    0xa000 - 2          ; Video segment (slightly shifted)
    pop     es
M:  mov     ax, 0xCCCD + 0x105  ; On first round, skew Rrrola trick to left
    mov     cl, 2
L:  mul     di                  ; Rrrola trick
    cmp     dl, 52              ; If (skewed) x is less than line width
    jb      S                   ; ...then jump to setting white pixel
    mov     ax, 0xCCCD - 0x105  ; On following round, skew right
    loop    L
    mov     al, 1               ; Otherwise, pixel is blue
    db      0x3D                ; (skip following instruction, this is some cmp)
S:  mov     al, 15
    stosb                       ; Put pixel on screen
    jmp     M
