const float zoom = 1.5;
const int maxiter = 100;
const float coloring_para = 52.0;
const float bps = 105. / 60.; // 115 beats per minute
const float tau = 6.28318;
const float per = 105. / 60. / 2.;
vec2 center = vec2(0.001643721971153, 0.822467633298876);

int escape(vec2 c) {
    float x = 0.0;
    float y = 0.0;
    float x2 = 0.0;
    float y2 = 0.0;
  
    for (int i = 0; i < maxiter; ++i) {
        if (x2 + y2 > 4.0) { return i; }
        y = 2.0 * x * y + c.y;
        x = x2 - y2 + c.x;
        x2 = x * x;
        y2 = y * y;
    }

    return maxiter;
}


float sawtooth(float t) {
    return t - floor(t);
}

float timer() {
    return iTime * (1. + 0.005*cos(tau*per*iTime) + 0.005*cos(1. + tau*per*iTime));
}

vec2 pos() {
    vec2 p = ((gl_FragCoord.xy / iResolution.xy ) - vec2(0.5, 0.5)) * 5.0;
    float x = center.x + p.x * pow(zoom, -timer());
    float y = center.y + p.y * pow(zoom, -timer());
    return vec2(x, y);
}


float regressColors() {
    return 60. - 1.5 * iTime;
}

float fade(float t) {
    if (t <= 4.) {
        return 0.25 * t;
    } 
    if (t >= 40.) {
        return 1.0 - 0.25*(t - 40.);
    }
    
    return 1.0;
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{    
    vec2 p = gl_FragCoord.xy / iResolution.xy; 

    int i = escape(pos());
    vec3 col;
    if (i >= maxiter) {
        col = vec3(0.0, 0.0, 0.0);
    } else {
        col = 0.5 + 0.5*cos((iTime+p.xyx+vec3(0,2,4)) * sawtooth(float(i) / regressColors()));     
    }

    fragColor = vec4(col * fade(iTime), 1.0);
}
