#version 460 core
in vec2 TexCoords;
in vec4 first;
out vec4 color;

uniform sampler2D text;
uniform vec3 textColor;
uniform float time;

void main()
{
	float moveX = gl_FragCoord.x / 1920.0f;
	float moveY = gl_FragCoord.y / 1080.0f;
	float pixelX = (first.x)-125. ;
	float pixelY = length(moveY) * sin(gl_SampleID);
	float texelX = TexCoords.x / distance(moveX, .5*first.x);
	float texelY = cos(gl_SampleID)*(TexCoords.y);
	vec2 texelXY = vec2(texelX, texelY);
	vec4 sampled = vec4(1.0, 1.0, 1.0, texture(text, texelXY).r);
	
	float effect = distance(texelX, pixelY);
	color = vec4(effect, textColor.x, textColor.y, 1.0) * sampled;
}