#version 460 core
in vec2 TexCoords;
in vec4 first;
out vec4 color;

uniform sampler2D text;
uniform vec3 textColor;
uniform float time;
vec4 sampled = vec4(0.0f);

void main()
{	
	float moveX = gl_FragCoord.x / 1920.0f ;
	float moveY = gl_FragCoord.y / 1080.0f ;
	
	float tx = TexCoords.x * 5.;
	float ty = TexCoords.y;
	
	float b = ( moveY )+ tx;
	float b2 = (moveY ) * (b);
	
	float pixelR = atan(ty)-1.5 * sin(time)*.26;
	
	float pixelG = tx +(moveY) + distance(  ty, roundEven(tx)) ;
	float pixelB =  tan(tx -.5)+cos(ty+1.5);
	float flimflam =(((pixelR )+ (moveY)));
	float texelX = b + 1.5 - pixelR * distance((moveY * tx)+5.5, pixelG/4.) ;
	
	float texelY = pixelG - round(b) + sign(flimflam ); // ( .1 * gl_SamplePosition.x);

	vec2 texelXY = vec2((TexCoords.x)*texelX + cos(moveY +time)*.2, TexCoords.y * texelY -tan(moveX -time)*.2);
	
	if(time < 50)sampled = vec4(1.0f, 1.0f, 1.0f, texture(text, texelXY).r);
	
	float effect = distance(texelX + (moveX)/3.0f * 60.0f , (moveX + texelY + sign(moveY))/3.0f * 60.0f );
	color = vec4(pixelR + effect, pixelG + effect, pixelB, 1.0)*	(cos(sampled));
}


	//sampled = vec4(1.0, 1.0f, 1.0, texture(text, texelXY-TexCoords.y+(atan(time))*.2 ).r);
	//sampled = vec4(1.0, 1.0f, 1.0, texture(text, texelXY-TexCoords.x/(atan(time))*.2 ).r);
	//sampled = vec4(1.0, 1.0f, 1.0, texture(text, texelXY-TexCoords.y+(atan(time))*.2 ).r);