monolith_colour = {233,36,92}
edges_colour = {10, 165, 185}
monoliths = {}
sidepanels = {}


monocols = 6
monorows = 20
monoheight = 1
monowidth = 0.5

for x = 1,monocols do
  monoliths[x] = {}
  for y = 1,monorows do
    monoliths[x][y] = model("monolith.stl")
    model_colour(monoliths[x][y],monolith_colour[1]/355,monolith_colour[2]/355,monolith_colour[3]/355,1)
    setvisible(monoliths[x][y],false)
  end
end
sidepanels[1] = model("monolith.stl")
sidepanels[2] = model("monolith.stl")
model_colour(sidepanels[1],edges_colour[1]/255, edges_colour[2]/255,edges_colour[3]/255,1)
model_colour(sidepanels[2],edges_colour[1]/255, edges_colour[2]/255,edges_colour[3]/255,1)
setvisible(sidepanels[1], false)
setvisible(sidepanels[2], false)

function floor_start()
  for x = 1,monocols do
    for y = 1,monorows do
      setvisible(monoliths[x][y],true)
    end
  end
  setvisible(sidepanels[1], true)
  setvisible(sidepanels[2], true)
end

function floor_frame()
  translate(sidepanels[1],-11.5,-1,-10)
  scale(sidepanels[1],40,1,monorows*monoheight+2);
  rotate(sidepanels[1],1,0,0,math.pi * 0.5)
  
  translate(sidepanels[2],11.5,-1,-10)
  scale(sidepanels[2],40,1,monorows*monoheight+2);
  rotate(sidepanels[2],1,0,0,math.pi * 0.5)

  for x = 1,monocols do for y = 1,monorows do
    monolith = monoliths[x][y]
    translate(monolith,
      -(monocols+1)*monowidth/2 + x*monowidth,-1,-((time_beats + y * 2 + (x % 2)) % 22 - 1)*monoheight)
    rotate(monolith,1,0,0,math.pi*0.5)
  end end
end

function floor_finish()
  for i, monolist in pairs(monoliths) do for j, monolith in pairs(monolist) do
    setvisible(monolith, false)
  end end
  for i, sidepanel in pairs(sidepanels) do
    setvisible(sidepanel, false)
  end
end