rainpyramid = {}
rainorb = {}
rainbowcols = {colour_bg, orb_colour, toob_colour}

flash_pos=0

function scene_rain_road_init()
  cls(0.1,0.1,0.45)
  setframe(0,0,1,1)
  floor_start()
  rainpyramid = model("pyramid.stl")
  rainorb = model("orb.stl")
  model_colour(rainorb,orb_colour[1]/255, orb_colour[2]/255,orb_colour[3]/255,1)
  model_colour(sidepanels[1],0.01, 0.01,0.01,1)
  model_colour(sidepanels[2],0.01, 0.01,0.01,1)
  model_colour(rainpyramid,0.01, 0.01,0.01,1)
  anthem_start_time = 0
end

function s_rr_rot(m)
  rotate(m,0,0,1,math.pi /18)
end

colour_decays = {}
for i=1,monocols do
  table.insert(colour_decays,0.1)
end

function scene_rain_road_frame(time_beats)
  setflatcolour(colour_bg[1]/64,colour_bg[2]/64,colour_bg[3]/64,0.1*math.max(0,time_beats-32)/16)

  function increment_flash()
    flash_pos = (flash_pos % monocols) + 1
    colour_decays[flash_pos] = 2
  end
  anthem_trigger(increment_flash, time_beats)
  for x = 1,monocols do
    c = {}
    for i = 1,3 do
      c[i] = rainbowcols[(x % #rainbowcols)+1][i] * colour_decays[x]
    end
    colour_decays[x] = colour_decays[x] *0.9
    for y = 1,monorows do
      monolith = monoliths[x][y]
      s_rr_rot(monolith)
      model_colour(monolith, c[1]/255,c[2]/255,c[3]/255,1)
    end
  end
  
  s_rr_rot(rainpyramid)
  s_rr_rot(rainorb)
  translate(rainpyramid,0.05,0.73,0)
  translate(rainorb,0.05,0.73,0)
  s_rr_rot(sidepanels[1])
  s_rr_rot(sidepanels[2])
  floor_frame()
  scale(rainpyramid,2,2,2)
  scale(rainorb,2,2,2)
  translate(rainpyramid,0,-0.3,-1)
  translate(rainorb,0,0.3,-1)
  
end

function scene_rain_road_finish()
    floor_finish()
    setvisible(rainpyramid,false)
    setvisible(rainorb,false)
end
