roads_monolith_colour = monolith_colour
roads_orb_colour = orb_colour
roads_toob_colour = toob_colour
roads = {}
bogroll = {}
bog_orb = {}

side_monocols = 6
side_monorows = 40
side_monoheight = 1
side_monowidth = 0.5

function make_road()
  roads_monoliths = {}
  for x = 1,side_monocols do
    roads_monoliths[x] = {}
    for y = 1,side_monorows do
      roads_monoliths[x][y] = model("monolith.stl")
      model_colour(roads_monoliths[x][y],roads_monolith_colour[1]/355,roads_monolith_colour[2]/355,roads_monolith_colour[3]/355,1)
    end
  end
  return roads_monoliths
end

function scene_roads_init()
  cls(colour_bg[1]/255,colour_bg[2]/255, colour_bg[3]/255)
  setframe(0,0.1,1,0.8)
  setflatcolour(toob_colour[1]/255, toob_colour[2]/255, toob_colour[3]/255,0)
  table.insert(roads,make_road())
  table.insert(roads,make_road())
  table.insert(roads,make_road())
  bogroll = model("bogroll.stl")
  bog_orb = model("orb.stl")
  model_colour(bog_orb, roads_orb_colour[1]/255, roads_orb_colour[2]/255, roads_orb_colour[3]/255, 1)
  model_colour(bogroll, roads_toob_colour[1]/255, roads_toob_colour[2]/255, roads_toob_colour[3]/255, 1)
end

function scene_roads_frame(time_beats)
  for i,roads_monoliths in pairs(roads) do
      for x = 1,side_monocols do for y = 1,side_monorows do
        monolith = roads_monoliths[x][y]
        rotate(monolith,0,1,0,math.pi*0.5)
        translate(monolith,
          i*5-(side_monocols+1)*side_monowidth/2 + x*side_monowidth,
          -2,
          (side_monorows)*side_monoheight/2-((time_beats+math.atan(math.sin((time_beats+i)*math.pi*2/8)) + y * 2 + (x % 2)) % side_monorows - 1)*side_monoheight
          --(side_monorows)*side_monoheight/2-((time_beats + y * 2 + (x % 2)) % side_monorows - 1)*side_monoheight
        )
        rotate(monolith,1,0,0,math.pi*0.5)
      end end
  end
  tb2 = time_beats-2
  translate(bogroll,
    2*((tb2%8)-4)*((tb2//8%2)*2-1),
    1,
    -1-tb2//8%3)
  translate(bog_orb,
    -2*((tb2/2%8)-4)*((tb2//16%2)*2-1),
    1,
    -1-tb2//16%3)
  scale(bog_orb, 0.7,0.7,0.7)
end

function scene_roads_finish()
  for h, roads_monoliths in pairs(roads) do for i, monolist in pairs(roads_monoliths) do for j, monolith in pairs(monolist) do
    setvisible(monolith, false)
  end end end
  setvisible(bogroll,false)
  setvisible(bog_orb,false)
end