toob_colour = {246,143,173}
toob_bg = colour_bg
wall_colour = {75,60,145}

walls = {}
holes = {}
train = {}
function scene_toobs_init()
  cls(colour_bg[1]/1555,colour_bg[2]/1555, colour_bg[3]/1555)
  
  setframe(0.2,0.02,0.8,0.98)
  setflatcolour(colour_bg[1]/255,colour_bg[2]/255, colour_bg[3]/255,0)
  walls = {
    model("monolith.stl"),
    model("monolith.stl")
  }
  holes = {
    model("cylinder.stl"),
    model("cylinder.stl"),
    model("cylinder.stl"),
    model("cylinder.stl")
  }
  model_colour(walls[1],colour_bg[1]/255,colour_bg[2]/255, colour_bg[3]/255,1)
  model_colour(walls[2],colour_bg[1]/255,colour_bg[2]/255, colour_bg[3]/255,1)
  for a,hole in pairs(holes) do
    model_colour(hole, colour_bg[1]/855,colour_bg[2]/855, colour_bg[3]/855,1)
  end
  train = model("cylinder.stl")
  model_colour(train, toob_colour[1]/255,toob_colour[2]/255,toob_colour[3]/255,1)
end

function scene_toobs_frame(time_beats)
  if time_beats > 30 then
    tc1 = math.max(math.min((time_beats - 30) /2,1),0)
    tc2 = 1 - tc1
    setflatcolour(
        colour_bg[1]* tc2/255 + 0.01*tc1,
        colour_bg[2]* tc2/255 + 0.01*tc1,
        colour_bg[3]* tc2/255 + 0.1*tc1,
        tc1
    )
  end
  translate(walls[1], -1, 0, 0)
  scale(walls[1],1,16,16)
  rotate(walls[1],0,1,0,math.pi*0.5)
  translate(walls[2], 1, 0, 0)
  scale(walls[2],1,16,16)
  rotate(walls[2],0,1,0,math.pi*0.5)
  
  for i=1,#holes do
    translate(holes[i], 1.18 * (1-2*(i % 2)), 1-(i-1)//2, 0)
    rotate(holes[i],0,1,0,math.pi*0.5)
    hole_size = (1 + math.atan(12*math.sin((time_beats/2 + i/2) * math.pi)-8))/2
    scale(holes[i], hole_size, hole_size, 1)
  end
  
  train_time = time_beats - 0.5
  translate(train, 0.5-(train_time%2), (train_time//2%2), 0)
  scale(train, 2,0.5,0.5)
  rotate(train, 0,1,0,math.pi/2)
  
end

function scene_toobs_finish()
  setvisible(train,false)
  for i,wall in pairs(walls) do setvisible(wall,false) end
  for i,hole in pairs(holes) do setvisible(hole,false) end
end