; "KBA"
; ZX Spectrum + AY 256b intro
; z80 code - .shahmatist^RMDA
; 12.08.2022, Samara, Russia

;---[Some tech info]--------------------------------------------

; Follow the ../toolchan rabbit

	DEVICE	ZXSPECTRUM48

	org	#c680
		
begin:	equ $

;-------IM2---------------------------------
	di
	ld	hl,#c900
	ld	a,h
	ld	i,a
	im	2
soop:	cp	h
	ld	(hl),a
	inc	hl
	add	ix,ix		;IX init
	jr	z,soop
;------------------------------------------

	ld	iyh,#20
	and	a
		
start:	ld	hl,color_end-1
iteration:
	ld	bc,0
	sbc	hl,bc
	ld	de,#581f
	ex	de,hl
	ld	iyl,iyh
	ld	c,iyl
color1:
	ld	a,(de)
	ld	(hl),a
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	dec	h
	dec	h
	dec	hl
	dec	de		

	dec	iyl
	jr	nz,color1

	ld	hl,color
	ld	a,(iteration+1)
	ld	c,a
	add	hl,bc
	ld	de,#5900
	ex	de,hl

	ld	iyl,iyh
	ld	c,iyl
	
color2:
	ld	a,(de)
	ld	(hl),a
	add	hl,bc
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	ld	(hl),a
	add	hl,bc
	dec	h
	dec	h
	inc	hl
	inc	de		
	dec	iyl
	jr	nz,color2
	ld	hl,iteration+1
	ld	a,#1f
	inc	(hl)
	and	(hl)
	ld	(hl),a

;-------AY---------------------------------------------------		
	ld	e,#0d
;	ld	e,c	;E=#0d for AY
;	ld	hl,begin+78;+3,+10,+32,_+37_,+45,+68,+_78_+73
;	ld h,#cb
ayl:	
	ld	bc,#fffd
	out	(c),e
	ld	b,#bf
	outi
	dec	e
	jr	nz,ayl
;------------------------------------------------------------		

	ld	iyl,8
Frame_start:
;------------------------------------------------------------
;keys:	
;	xor	a
;	in	a,(254)
;;	cpl			;!!!
;;	and	#1f		;!!!
;	inc	a
;	jr	nz,keys

	ei
	halt

;-------BORDER----------------------------------------------		
	inc	ix
	ld	a,ixh
	out	(#fe),a
;-----------------------------------------------------------
		
Up_mask:	
	scf
Up_mask1:
	ld	a,#00
	rra
	ld	d,a
	ld	(Up_mask1+1),a
	cpl
	ld	e,a
	ld	hl,#4020
	ld	c,8
	ld	a,l
Up_roll3:
	ld	b,8
Up_roll:		
	ld	sp,hl
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
		
	inc	h
		
	djnz	Up_roll

	ld	h,#40
	add	a,32
	ld	l,a
	jr	nc,Up_roll2
		
	inc	h
				
Up_roll2:
	dec c
	jr nz,Up_roll3
	ld hl,#4840
		
	ld	c,4
	ld	a,l
Mid_roll3:
	ld	b,8
Mid_roll:		
	ld	sp,hl
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	inc h
	djnz Mid_roll
	ld h,#48
	add a,64
	ld l,a
	jr nc,Mid_roll2
	inc h	
Mid_roll2:
	dec c
	jr nz,Mid_roll3		

Down_mask:	
	and	a
Down_mask1:		
	ld	a,#ff
	rla	
	ld	d,a
	ld	(Down_mask1+1),a
	cpl
	ld	e,a

	ld	hl,#4820

	ld	c,4
	ld	a,l
Mid_roll_03:		
	ld	b,8
Mid_roll_01:
		
	ld sp,hl
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	inc h
	djnz Mid_roll_01
	ld h,#48
	add a,64
	ld l,a
	jr nc,Mid_roll_02
	inc h
Mid_roll_02:		
	dec c
	jr nz,Mid_roll_03
	ld h,#50
	ld c,8
	ld a,l
Down_roll_3:		
	ld	b,8
Down_roll:
	ld sp,hl
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	inc h		
	djnz Down_roll

	ld	h,#50
	add	a,32
	ld	l,a
	jr	nc,Down_roll_2
	inc	h

Down_roll_2:		
	dec c
	jr	nz,Down_roll_3

	dec	iyl
	jp	nz,Frame_start

	ld	hl,Down_mask
	ld	a,(hl)
	ld	(Up_mask),a
	xor	#90
	ld	(hl),a

	jp	start
;--------------------------------------------------------------------
color:
;	DUP	2     
	DUP	8	;DUP 2 is enought but DUP 8 to alligne code

	DEFB	%00010001 ;#11	

		
	DEFB	%00010001 ;#11
	DEFB	%00010011 ;#13
	DEFB	%00100011 ;#23
	DEFB	%00100101 ;#25
	DEFB	%00110101 ;#35		
	DEFB	%00110001 ;#31
	
	DEFB	%00010001 ;#11
	DEFB	%00010011 ;13		
	DEFB	%00100011 ;23
	DEFB	%00100101 ;25
	DEFB	%00110101 ;35	
	DEFB	%00110001 ;31
		
	DEFB	%00010001 ;11
	DEFB	%00010011 ;13
	DEFB	%00100011
	DEFB	%00100101
	DEFB	%00110101
	DEFB	%00110001		

	DEFB	%00010001
	DEFB	%00010011		
	DEFB	%00100011
	DEFB	%00100101
	DEFB	%00110101		
	DEFB	%00110001
	
	DEFB	%00010001;11
	DEFB	%00010011;13
	DEFB	%00100011
	DEFB	%00100101
	DEFB	%00110101
	DEFB	%00110001		

	DEFB	%00010001

	EDUP

color_end:

	defb	#ff
	defb	#ff
fin:

	SAVESNA	"KVA.sna", begin
	SAVEBIN	"KVA.bin", begin,fin-begin

;-------=RMDA=---------------------------------------------[eof]