;
;    Purple by bitl/7dump (2022)
;      ___                 .
;  _.-|   |          |\__/,|   (`\
; {   |   |          |o o  |__ _) )
;  "-.|___|        _.( T   )  ` ./
;  .--'-`-.     _((_ `^--' /_<  \
;.+|______|__.-||__)`-'(((/  (((/
;   GrEetZ t0 aLl $izE-c0deRs! ;)
;
; P.S.: this code for TASM (MS-DOS)!
; For compilation: "tasm purple.asm",  "tlink /t purple.obj")

.model tiny
.data
       D  DW 80
       N  DW 0

.code
.486

org 0100h

start:
     mov al, 13h
     ;int 10h

     add dh, al
     mov es, dx          ; use segment cs+1300h for framebuffer

     xor dx, dx
@pal:                    ; Palette (blue+red gradient for all 256 colors)
     int 10h
     add dx, 64
     mov cl, dh
     mov ax, 1010h
     inc bl
     jnz @pal

     shl al, 2           ; fill framebuffer to color 64
     mov ch, 250
     rep stosb


     finit               ; init FPU
     fldz
     fldl2e              ; call magic value ;)
     fmul st, st

@mainloop:
                         ; draw comets
     mov cl, 100         ; y-center
     mov di, 150         ; x-center

     fadd st(1), st      ; incremental var
     fld st(1)
     fsin
     fild D  ; D
     fmul st, st(1)

     lea bx, word ptr N
     fist word ptr [bx]  ; X = sin(incvar)*D
     add di, word ptr [bx]

     fld st(3)
     fcos
     fmul st, st(1)
     fistp word ptr [bx] ; Y = cos(incvar)*X
     fstp st
     fstp st

                         ; make screen offset
     add cx, word ptr [bx]

     mov  dx, 320        ; DX=320 will use next
     imul cx, dx
     add  di, cx
     mov  ax, 0ffffh     ; color
     stosw

     mov cx, 10          ; count random dots

@rand:

     in ax, 40h          ; Pseudo random
     xadd ds:[100h], ax

                         ; draw random dots
     mov di, ax
     stosb

     loop @rand


@limiter:                ; make random Y (0..101) for scale-routine
     cmp al, 101
     jbe @continue
     shr al, 1
     jmp @limiter


@continue:
     xor ah, ah
     ;inc al

     push ds             ; store DS

     push es
     pop  ds             ; setup DS to framebuffer address


                         ; Vertical scale

     mov di, 200*320
     mov si, (200-1)*320

     mov bx, ax     ; save Y
     imul ax, 80

     mov cx, ax
     std
     rep movsd

     xor di, di
     mov si, dx     ; =320
     xchg cx, ax         ; less than "mov cx, ax"
     cld
     rep movsd

                         ; horizontal scale
     xor di, di
     mov si, 1

     add bx, 60     ; Y+60
     sub dx, bx     ; 320-BX

     mov ax, 0c8c8h ;(ah=200, al=200)

@loop1:
     mov cx, bx
     rep movsb
     add di, dx
     add si, dx
     dec al
jnz @loop1
     mov di, 320*200-1
     mov si, 320*200-2
     std
@loop2:
     mov cx, bx
     rep movsb
     sub si, dx
     sub di, dx
     dec ah
jnz @loop2

     cld

                         ; blur framebuffer
     xor si, si
     mov di, 1
     mov ch, 125  ; CX=32000
@blur:
     lodsb
     mov dl, ds:[si+1]
     add ax, dx
     mov dl, ds:[si-320]
     add ax, dx
     mov dl, ds:[si+320]
     add ax, dx
     shr ax, 2
     stosb
     inc si
     inc di
     loop @blur

                         ; wait for vertical retrace
;     mov  dx, 3DAh
@w1:
;     in   al, dx
;     test al, 8
;     jnz  @w1
@w2:
;     in   al, dx
;     test al, 8
;     jz   @w2

                         ; copy buffer to screen
     push 0a000h
     pop es
     xor di, di
     xor si, si
     mov ch, 125  ; CX=32000
     rep movsw

     push ds
     pop es              ; restore framebuffer address in ES

     pop ds              ; restore DS


     in al, 60h          ; wait for ESC
     dec al
     jnz @mainloop

     ;EXIT
     mov ax, 3           ; back to text-mode
     int 10h
     int 20h             ; exit

end start


