#pragma once

#include <GL/glew.h>

namespace cg_engine {
	class Matrix {
		private:
			GLfloat m[16];
		public:
			Matrix();
			~Matrix();
			Matrix operator * (Matrix &right);
			void perspective(double fov, double aspect, double near, double far);
			void translate(double x, double y, double z);
			void rotate(double rx, double ry, double rz);
			void lookAt(double *eye, double *target, double *up);
			void scale(double sx, double sy, double sz);
			GLfloat *matrix();
	};
//void matrixMultiply4x4(float *a, float *b, float *c);


//void blender2opengl(float *pos);
//void blender2openglmatrix(float *matrix);
}
