#pragma once

#include <GL/glew.h>
#include <vector>
#include "MeshIndex.hpp"

namespace cg_engine {
	class Mesh3D
	{
	private:
		const static int BUFFERNUM = 4;
		enum {VERTEX, NORMAL, TEXTURE, INDEX};

		std::vector<GLfloat>    vbuffer;  //TODO somehow add custom buffers
		std::vector<GLfloat>    tbuffer;
		std::vector<GLfloat>    nbuffer;
		std::vector<MeshIndex*> ibuffer;

		GLfloat                 *normals;
		GLfloat                 *textcoord;
		GLuint                  *indices;

		int                      i_count;
		int                      t_count;

		bool                     has_normals;
		bool                     has_texture;

		GLuint vertexarray;
		GLuint buffers[BUFFERNUM];
		void createOpenGLBinding();
		void buildMesh();
	public:
		Mesh3D(char *filename);
		~Mesh3D(void);
		void draw();
		void loadOBJ(char *filename);
	};
}

