    
    // This music has been exported by SoundBox. You can use it with
    // http://sb.bitsnbites.eu/player-small.js in your own product.

    // See http://sb.bitsnbites.eu/demo.html for an example of how to
    // use it in a demo.

    // Song data
    var song = {
        d: [
          { // Instrument 0
            i: [
            1, // OSC1_WAVEFORM
            234, // OSC1_VOL
            128, // OSC1_SEMI
            0, // OSC1_XENV
            2, // OSC2_WAVEFORM
            198, // OSC2_VOL
            116, // OSC2_SEMI
            9, // OSC2_DETUNE
            0, // OSC2_XENV
            0, // NOISE_VOL
            5, // ENV_ATTACK
            17, // ENV_SUSTAIN
            33, // ENV_RELEASE
            0, // ENV_EXP_DECAY
            0, // ARP_CHORD
            0, // ARP_SPEED
            3, // LFO_WAVEFORM
            162, // LFO_AMT
            3, // LFO_FREQ
            1, // LFO_FX_FREQ
            3, // FX_FILTER
            23, // FX_FREQ
            167, // FX_RESONANCE
            2, // FX_DIST
            24, // FX_DRIVE
            100, // FX_PAN_AMT
            6, // FX_PAN_FREQ
            25, // FX_DELAY_AMT
            6 // FX_DELAY_TIME
            ],
            // Patterns
            p: [,,,,,,,,,,,,,,,,1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,4,5],
            // Columns
            c: [
              {n: [128,125,132,128,137,132,140,137,144,140,149,144,152,149,156,149,152,144,149,140,144,137,140,132,137,128,132,125,128,120,125,127],
               f: []},
              {n: [128,125,133,128,137,133,140,137,145,140,149,145,152,149,157,149,152,145,149,140,145,137,140,133,137,128,133,125,128,121,125,127],
               f: []},
              {n: [128,125,134,128,137,134,140,137,146,140,149,146,152,149,158,149,152,146,149,140,146,137,140,134,137,128,134,125,128,122,125,127],
               f: []},
              {n: [125,130,133,130,137,133,142,137,145,142,149,145,154,149,157,154,151,154,148,151,144,148,142,144,139,142,136,139,132,136,130,133],
               f: []},
              {n: [125],
               f: []}
            ]
          },
          { // Instrument 1
            i: [
            3, // OSC1_WAVEFORM
            224, // OSC1_VOL
            116, // OSC1_SEMI
            57, // OSC1_XENV
            3, // OSC2_WAVEFORM
            214, // OSC2_VOL
            116, // OSC2_SEMI
            0, // OSC2_DETUNE
            37, // OSC2_XENV
            14, // NOISE_VOL
            4, // ENV_ATTACK
            6, // ENV_SUSTAIN
            73, // ENV_RELEASE
            99, // ENV_EXP_DECAY
            0, // ARP_CHORD
            0, // ARP_SPEED
            3, // LFO_WAVEFORM
            142, // LFO_AMT
            0, // LFO_FREQ
            1, // LFO_FX_FREQ
            2, // FX_FILTER
            24, // FX_FREQ
            78, // FX_RESONANCE
            0, // FX_DIST
            113, // FX_DRIVE
            0, // FX_PAN_AMT
            0, // FX_PAN_FREQ
            36, // FX_DELAY_AMT
            6 // FX_DELAY_TIME
            ],
            // Patterns
            p: [,,,,,,,,,,,,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15],
            // Columns
            c: [
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [142,,142,,,,,142,142,,142,,,,,142,142,,142,,,,,142,142,,142,,,,,142],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [142,,,,,,,,,,,,,,,,142],
               f: []},
              {n: [142],
               f: []}
            ]
          },
          { // Instrument 2
            i: [
            3, // OSC1_WAVEFORM
            100, // OSC1_VOL
            128, // OSC1_SEMI
            0, // OSC1_XENV
            3, // OSC2_WAVEFORM
            201, // OSC2_VOL
            128, // OSC2_SEMI
            0, // OSC2_DETUNE
            0, // OSC2_XENV
            0, // NOISE_VOL
            5, // ENV_ATTACK
            6, // ENV_SUSTAIN
            58, // ENV_RELEASE
            0, // ENV_EXP_DECAY
            0, // ARP_CHORD
            0, // ARP_SPEED
            0, // LFO_WAVEFORM
            0, // LFO_AMT
            4, // LFO_FREQ
            1, // LFO_FX_FREQ
            2, // FX_FILTER
            135, // FX_FREQ
            0, // FX_RESONANCE
            0, // FX_DIST
            41, // FX_DRIVE
            147, // FX_PAN_AMT
            6, // FX_PAN_FREQ
            123, // FX_DELAY_AMT
            6 // FX_DELAY_TIME
            ],
            // Patterns
            p: [6,11,12,13,6,11,12,13,6,11,12,13,6,11,12,13,,,,,,,,,6,11,12,13,6,11,12,13,6,5,4,3,6,5,4,3,6,11,12,13,6,5,4,3,6,11,12,13,14,15],
            // Columns
            c: [
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [145,,,,,,,,142,,,,,,,,144,,,,,,,,151,,,,,,,,,,,,133,,,,,,,,130,,,,,,,,132,,,,,,,,139],
               f: []},
              {n: [146,,,,,,,,149,,,,,,,,152,,,,,,,,149,,,,,,,,,,,,134,,,,,,,,137,,,,,,,,140,,,,,,,,137],
               f: []},
              {n: [157,,,,,,,,152,,,,,,,,149,,,,,,,,145,,,,,,,,,,,,145,,,,,,,,140,,,,,,,,137,,,,,,,,133],
               f: []},
              {n: [152,,,,,,,,156,,,,,,,,149,,,,,,,,152,,,,,,,,,,,,140,,,,,,,,144,,,,,,,,137,,,,,,,,140],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [,,,,142,,,,,,,,142,,,,,,,,142,,,,,,142,142,142,142,142,142],
               f: []},
              {n: [],
               f: []},
              {n: [145,,,,,,,,149,,,,,,,,140,,,,,,,,145,,,,,,,,,,,,128,,,,,,,,125,,,,,,,,128,,,,,,,,133],
               f: []},
              {n: [146,,,,,,,,140,,,,,,,,149,,,,,,,,146,,,,,,,,,,,,134,,,,,,,,128,,,,,,,,137,,,,,,,,134],
               f: []},
              {n: [145,,,,,,,,149,,,,,,,,148,,,,,,,,144,,,,,,,,,,,,133,,,,,,,,137,,,,,,,,136,,,,,,,,132],
               f: []},
              {n: [137,,,,,,,,,,,,,,,,113,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,125],
               f: []},
              {n: [],
               f: []}
            ]
          },
          { // Instrument 3
            i: [
            3, // OSC1_WAVEFORM
            100, // OSC1_VOL
            128, // OSC1_SEMI
            0, // OSC1_XENV
            2, // OSC2_WAVEFORM
            201, // OSC2_VOL
            128, // OSC2_SEMI
            0, // OSC2_DETUNE
            0, // OSC2_XENV
            0, // NOISE_VOL
            0, // ENV_ATTACK
            6, // ENV_SUSTAIN
            29, // ENV_RELEASE
            0, // ENV_EXP_DECAY
            0, // ARP_CHORD
            0, // ARP_SPEED
            0, // LFO_WAVEFORM
            195, // LFO_AMT
            4, // LFO_FREQ
            1, // LFO_FX_FREQ
            2, // FX_FILTER
            50, // FX_FREQ
            184, // FX_RESONANCE
            119, // FX_DIST
            244, // FX_DRIVE
            147, // FX_PAN_AMT
            6, // FX_PAN_FREQ
            84, // FX_DELAY_AMT
            6 // FX_DELAY_TIME
            ],
            // Patterns
            p: [,,,,,,,,7,7,7,7,7,7,7,8,7,7,7,7,7,7,7,8,7,7,7,7,7,7,7,8,7,7,7,7,7,7,7,8,7,9,10,8,7,9,10,8,11],
            // Columns
            c: [
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [113,,113,,125,,113,,113,113,125,113,113,,125,,113,,113,,125,,113,,113,,113,,113,125,113],
               f: []},
              {n: [118,,118,,130,,118,130,118,,118,,120,,121,,120,132,120,,132,,120,,120,,120,132,120,,120],
               f: []},
              {n: [121,,121,,133,,121,,121,121,133,121,121,,133,,121,,121,,133,,121,,121,,121,,121,133,121],
               f: []},
              {n: [118,,118,,130,,118,,118,118,130,118,118,,130,,118,,118,,130,,118,,118,,118,,118,130,118],
               f: []},
              {n: [113],
               f: []}
            ]
          },
          { // Instrument 4
            i: [
            0, // OSC1_WAVEFORM
            0, // OSC1_VOL
            140, // OSC1_SEMI
            0, // OSC1_XENV
            0, // OSC2_WAVEFORM
            0, // OSC2_VOL
            140, // OSC2_SEMI
            0, // OSC2_DETUNE
            0, // OSC2_XENV
            81, // NOISE_VOL
            4, // ENV_ATTACK
            10, // ENV_SUSTAIN
            47, // ENV_RELEASE
            55, // ENV_EXP_DECAY
            0, // ARP_CHORD
            0, // ARP_SPEED
            0, // LFO_WAVEFORM
            187, // LFO_AMT
            5, // LFO_FREQ
            1, // LFO_FX_FREQ
            1, // FX_FILTER
            239, // FX_FREQ
            135, // FX_RESONANCE
            0, // FX_DIST
            32, // FX_DRIVE
            108, // FX_PAN_AMT
            5, // FX_PAN_FREQ
            16, // FX_DELAY_AMT
            4 // FX_DELAY_TIME
            ],
            // Patterns
            p: [,,,,10,10,10,15,10,10,10,15,,,,,,,,,10,10,10,15,10,10,10,15,10,10,10,15,10,10,10,15,10,10,10,15,10,10,10,15,10,10,10,15],
            // Columns
            c: [
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [123,,,123,123,,,,123,,,123,123,,,,123,,,,123,123,,,123,,,,123,123],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [123,,,123,123,,,,123,,123,,123,123,,,123,,,123,123,,123,,123,123,123,,123],
               f: []}
            ]
          },
          { // Instrument 5
            i: [
            2, // OSC1_WAVEFORM
            221, // OSC1_VOL
            128, // OSC1_SEMI
            64, // OSC1_XENV
            1, // OSC2_WAVEFORM
            210, // OSC2_VOL
            128, // OSC2_SEMI
            70, // OSC2_DETUNE
            64, // OSC2_XENV
            255, // NOISE_VOL
            4, // ENV_ATTACK
            6, // ENV_SUSTAIN
            73, // ENV_RELEASE
            79, // ENV_EXP_DECAY
            0, // ARP_CHORD
            0, // ARP_SPEED
            0, // LFO_WAVEFORM
            64, // LFO_AMT
            7, // LFO_FREQ
            1, // LFO_FX_FREQ
            2, // FX_FILTER
            195, // FX_FREQ
            15, // FX_RESONANCE
            6, // FX_DIST
            32, // FX_DRIVE
            20, // FX_PAN_AMT
            0, // FX_PAN_FREQ
            24, // FX_DELAY_AMT
            6 // FX_DELAY_TIME
            ],
            // Patterns
            p: [,,,,,,,,,,,,,,,,,,,,,,,,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15],
            // Columns
            c: [
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [],
               f: []},
              {n: [,,,,,,,,137,,,,,,,,,,,,,,,,137],
               f: []}
            ]
          },
          { // Instrument 6
            i: [
            1, // OSC1_WAVEFORM
            236, // OSC1_VOL
            140, // OSC1_SEMI
            130, // OSC1_XENV
            2, // OSC2_WAVEFORM
            227, // OSC2_VOL
            140, // OSC2_SEMI
            101, // OSC2_DETUNE
            166, // OSC2_XENV
            255, // NOISE_VOL
            158, // ENV_ATTACK
            57, // ENV_SUSTAIN
            178, // ENV_RELEASE
            92, // ENV_EXP_DECAY
            0, // ARP_CHORD
            0, // ARP_SPEED
            1, // LFO_WAVEFORM
            69, // LFO_AMT
            7, // LFO_FREQ
            1, // LFO_FX_FREQ
            2, // FX_FILTER
            46, // FX_FREQ
            239, // FX_RESONANCE
            164, // FX_DIST
            170, // FX_DRIVE
            164, // FX_PAN_AMT
            13, // FX_PAN_FREQ
            156, // FX_DELAY_AMT
            11 // FX_DELAY_TIME
            ],
            // Patterns
            p: [,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,2],
            // Columns
            c: [
              {n: [],
               f: []},
              {n: [111],
               f: []}
            ]
          },
        ],
        W: 4658,   // In sample lengths
        Z: 32,  // Rows per pattern
        Y: 53,  // End pattern
        X: 7  // Number of channels
      };
  
      /* -*- mode: javascript; tab-width: 4; indent-tabs-mode: nil; -*-
*
* Copyright (c) 2011-2013 Marcus Geelnard
*
* This software is provided 'as-is', without any express or implied
* warranty. In no event will the authors be held liable for any damages
* arising from the use of this software.
*
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
*
* 1. The origin of this software must not be misrepresented; you must not
*    claim that you wrote the original software. If you use this software
*    in a product, an acknowledgment in the product documentation would be
*    appreciated but is not required.
*
* 2. Altered source versions must be plainly marked as such, and must not be
*    misrepresented as being the original software.
*
* 3. This notice may not be removed or altered from any source
*    distribution.
*
*/

"use strict";

// Some general notes and recommendations:
//  * This code uses modern ECMAScript features, such as ** instead of
//    Math.pow(). You may have to modify the code to make it work on older
//    browsers.
//  * If you're not using all the functionality (e.g. not all oscillator types,
//    or certain effects), you can reduce the size of the player routine even
//    further by deleting the code.


var CPlayer = function() {

    //--------------------------------------------------------------------------
    // Private methods
    //--------------------------------------------------------------------------

    // Oscillators
    var osc_sin = function (value) {
        return Math.sin(value * 6.283184);
    };

    var osc_saw = function (value) {
        return 2 * (value % 1) - 1;
    };

    var osc_square = function (value) {
        return (value % 1) < 0.5 ? 1 : -1;
    };

    var osc_tri = function (value) {
        var v2 = (value % 1) * 4;
        if(v2 < 2) return v2 - 1;
        return 3 - v2;
    };

    var getnotefreq = function (n) {
        // 174.61.. / 44100 = 0.003959503758 (F3)
        return 0.003959503758 * (2 ** ((n - 128) / 12));
    };

    var createNote = function (instr, n, rowLen) {
        var osc1 = mOscillators[instr.i[0]],
            o1vol = instr.i[1],
            o1xenv = instr.i[3]/32,
            osc2 = mOscillators[instr.i[4]],
            o2vol = instr.i[5],
            o2xenv = instr.i[8]/32,
            noiseVol = instr.i[9],
            attack = instr.i[10] * instr.i[10] * 4,
            sustain = instr.i[11] * instr.i[11] * 4,
            release = instr.i[12] * instr.i[12] * 4,
            releaseInv = 1 / release,
            expDecay = -instr.i[13]/16,
            arp = instr.i[14],
            arpInterval = rowLen * (2 **(2 - instr.i[15]));

        var noteBuf = new Int32Array(attack + sustain + release);

        // Re-trig oscillators
        var c1 = 0, c2 = 0;

        // Local variables.
        var j, j2, e, t, rsample, o1t, o2t;

        // Generate one note (attack + sustain + release)
        for (j = 0, j2 = 0; j < attack + sustain + release; j++, j2++) {
            if (j2 >= 0) {
                // Switch arpeggio note.
                arp = (arp >> 8) | ((arp & 255) << 4);
                j2 -= arpInterval;

                // Calculate note frequencies for the oscillators
                o1t = getnotefreq(n + (arp & 15) + instr.i[2] - 128);
                o2t = getnotefreq(n + (arp & 15) + instr.i[6] - 128) * (1 + 0.0008 * instr.i[7]);
            }

            // Envelope
            e = 1;
            if (j < attack) {
                e = j / attack;
            } else if (j >= attack + sustain) {
                e = (j - attack - sustain) * releaseInv;
                e = (1 - e) * (3 ** (expDecay * e));
            }

            // Oscillator 1
            c1 += o1t * e ** o1xenv;
            rsample = osc1(c1) * o1vol;

            // Oscillator 2
            c2 += o2t * e ** o2xenv;
            rsample += osc2(c2) * o2vol;

            // Noise oscillator
            if (noiseVol) {
                rsample += (2 * Math.random() - 1) * noiseVol;
            }

            // Add to (mono) channel buffer
            noteBuf[j] = (80 * rsample * e) | 0;
        }

        return noteBuf;
    };


    //--------------------------------------------------------------------------
    // Private members
    //--------------------------------------------------------------------------

    // Array of oscillator functions
    var mOscillators = [
        osc_sin,
        osc_square,
        osc_saw,
        osc_tri
    ];

    // Private variables set up by init()
    var mSong, mLastRow, mCurrentCol, mNumWords, mMixBuf;


    //--------------------------------------------------------------------------
    // Initialization
    //--------------------------------------------------------------------------

    this.i = function (song) {
        // Define the song
        mSong = song;

        // Init iteration state variables
        mLastRow = song.Y;
        mCurrentCol = 0;

        // Prepare song info
        mNumWords =  song.W * song.Z * (mLastRow + 1) * 2;

        // Create work buffer (initially cleared)
        mMixBuf = new Int32Array(mNumWords);
    };


    //--------------------------------------------------------------------------
    // Public methods
    //--------------------------------------------------------------------------

    // Generate audio data for a single track
    this.g = function () {
        // Local variables
        var i, j, b, p, row, col, n, cp,
            k, t, lfor, e, x, rsample, rowStartSample, f, da;

        // Put performance critical items in local variables
        var chnBuf = new Int32Array(mNumWords),
            instr = mSong.d[mCurrentCol],
            rowLen = mSong.W,
            patternLen = mSong.Z;

        // Clear effect state
        var low = 0, band = 0, high;
        var lsample, filterActive = false;

        // Clear note cache.
        var noteCache = [];

         // Patterns
         for (p = 0; p <= mLastRow; ++p) {
            cp = instr.p[p];

            // Pattern rows
            for (row = 0; row < patternLen; ++row) {
                // Execute effect command.
                var cmdNo = cp ? instr.c[cp - 1].f[row] : 0;
                if (cmdNo) {
                    instr.i[cmdNo - 1] = instr.c[cp - 1].f[row + patternLen] || 0;

                    // Clear the note cache since the instrument has changed.
                    if (cmdNo < 17) {
                        noteCache = [];
                    }
                }

                // Put performance critical instrument properties in local variables
                var oscLFO = mOscillators[instr.i[16]],
                    lfoAmt = instr.i[17] / 512,
                    lfoFreq = (2 ** (instr.i[18] - 9)) / rowLen,
                    fxLFO = instr.i[19],
                    fxFilter = instr.i[20],
                    fxFreq = instr.i[21] * 43.23529 * 3.141592 / 44100,
                    q = 1 - instr.i[22] / 255,
                    dist = instr.i[23] * 1e-5,
                    drive = instr.i[24] / 32,
                    panAmt = instr.i[25] / 512,
                    panFreq = 6.283184 * (2 ** (instr.i[26] - 9)) / rowLen,
                    dlyAmt = instr.i[27] / 255,
                    dly = instr.i[28] * rowLen & ~1;  // Must be an even number

                // Calculate start sample number for this row in the pattern
                rowStartSample = (p * patternLen + row) * rowLen;

                // Generate notes for this pattern row
                for (col = 0; col < 4; ++col) {
                    n = cp ? instr.c[cp - 1].n[row + col * patternLen] : 0;
                    if (n) {
                        if (!noteCache[n]) {
                            noteCache[n] = createNote(instr, n, rowLen);
                        }

                        // Copy note from the note cache
                        var noteBuf = noteCache[n];
                        for (j = 0, i = rowStartSample * 2; j < noteBuf.length; j++, i += 2) {
                          chnBuf[i] += noteBuf[j];
                        }
                    }
                }

                // Perform effects for this pattern row
                for (j = 0; j < rowLen; j++) {
                    // Dry mono-sample
                    k = (rowStartSample + j) * 2;
                    rsample = chnBuf[k];

                    // We only do effects if we have some sound input
                    if (rsample || filterActive) {
                        // State variable filter
                        f = fxFreq;
                        if (fxLFO) {
                            f *= oscLFO(lfoFreq * k) * lfoAmt + 0.5;
                        }
                        f = 1.5 * Math.sin(f);
                        low += f * band;
                        high = q * (rsample - band) - low;
                        band += f * high;
                        rsample = fxFilter == 3 ? band : fxFilter == 1 ? high : low;

                        // Distortion
                        if (dist) {
                            rsample *= dist;
                            rsample = rsample < 1 ? rsample > -1 ? osc_sin(rsample*.25) : -1 : 1;
                            rsample /= dist;
                        }

                        // Drive
                        rsample *= drive;

                        // Is the filter active (i.e. still audiable)?
                        filterActive = rsample * rsample > 1e-5;

                        // Panning
                        t = Math.sin(panFreq * k) * panAmt + 0.5;
                        lsample = rsample * (1 - t);
                        rsample *= t;
                    } else {
                        lsample = 0;
                    }

                    // Delay is always done, since it does not need sound input
                    if (k >= dly) {
                        // Left channel = left + right[-p] * t
                        lsample += chnBuf[k-dly+1] * dlyAmt;

                        // Right channel = right + left[-p] * t
                        rsample += chnBuf[k-dly] * dlyAmt;
                    }

                    // Store in stereo channel buffer (needed for the delay effect)
                    chnBuf[k] = lsample | 0;
                    chnBuf[k+1] = rsample | 0;

                    // ...and add to stereo mix buffer
                    mMixBuf[k] += lsample | 0;
                    mMixBuf[k+1] += rsample | 0;
                }
            }
        }

        // Next iteration. Return progress (1.0 == done!).
        mCurrentCol++;
        return mCurrentCol / mSong.X;
    };

    // // Create a AudioBuffer from the generated audio data
    // this.createAudioBuffer = function(context) {
    //     var buffer = context.createBuffer(2, mNumWords / 2, 44100);
    //     for (var i = 0; i < 2; i ++) {
    //         var data = buffer.getChannelData(i);
    //         for (var j = i; j < mNumWords; j += 2) {
    //             data[j >> 1] = mMixBuf[j] / 65536;
    //         }
    //     }
    //     return buffer;
    // };
    
    // Create a WAVE formatted Uint8Array from the generated audio data
    this.w = function() {
        // Create WAVE header
        var headerLen = 44;
        var l1 = headerLen + mNumWords * 2 - 8;
        var l2 = l1 - 36;
        var wave = new Uint8Array(headerLen + mNumWords * 2);
        wave.set(
            [82,73,70,70,
             l1 & 255,(l1 >> 8) & 255,(l1 >> 16) & 255,(l1 >> 24) & 255,
             87,65,86,69,102,109,116,32,16,0,0,0,1,0,2,0,
             68,172,0,0,16,177,2,0,4,0,16,0,100,97,116,97,
             l2 & 255,(l2 >> 8) & 255,(l2 >> 16) & 255,(l2 >> 24) & 255]
        );

        // Append actual wave data
        for (var i = 0, idx = headerLen; i < mNumWords; ++i) {
            // Note: We clamp here
            var y = mMixBuf[i];
            y = y < -32767 ? -32767 : (y > 32767 ? 32767 : y);
            wave[idx++] = y & 255;
            wave[idx++] = (y >> 8) & 255;
        }

        // Return the WAVE formatted typed array
        return wave;
    };

    // Get n samples of wave data at time t [s]. Wave data in range [-2,2].
    // this.getData = function(t, n) {
    //     var i = 2 * Math.floor(t * 44100);
    //     var d = new Array(n);
    //     for (var j = 0; j < 2*n; j += 1) {
    //         var k = i + j;
    //         d[j] = t > 0 && k < mMixBuf.length ? mMixBuf[k] / 32768 : 0;
    //     }
    //     return d;
    // };
};

"use strict";
// // options
// {
//     toplevel: true,
//     compress: {
//       passes: 5,
//       unsafe: true,
//       pure_getters: true
//     },
//   }
// // options
// {
//     toplevel: true,
//     compress: {
//       passes: 5,
//       unsafe: true,
//       pure_getters: true
//     },
//   }
"use strict";

const a = document.createElement`canvas`
document.body.appendChild(a)

const c = a.getContext`2d`

const w = 1920
const h = 1080
const FN = 'px serif'
const audio = document.createElement`audio`
const player = new CPlayer()

let randomSeed = 0x12341234 //adefe51a
//https://gist.github.com/blixt/f17b47c62508be59987b
function randomNextFloat() {
    randomSeed = randomSeed * 16807 % 2147483647
    return (randomSeed - 1) / 2147483646
}
function easeOut(x, y, t) {
    if (t < 0) t = 0
    if (t > 1.0) t = 1.0
    const _t = 1.0 - (1.0 - t) * (1.0 - t)
    return x * (1 - _t) + y * _t
}

a.style.position = 'absolute'
a.style.left = a.style.top = 0
a.style.width = "100%"
a.style.height = "100%"

player.i(song)
let state = false

const E = c.createLinearGradient(0, 0, 0, h)
E.addColorStop(0, '#101')
E.addColorStop(1, '#000')

const treel = []
const pt = []
const pt2 = []
const acc = []
const bubbles = []

let zoff = 0
let treeCircleAlpha = 0
let pointsAlpha = 0
let titleAlpha = 0
let bubbleAlpha = 0
let lastT = 0
let bubbleidx = 0
let treeidx = 0
let accidx = 0
let accTime = 0
let accTimeT = 0
let bubblesGen = 0

function generatePoint(j, spread=false) {
    const k = (j + treeidx) * 4
    const r = w * 3 * (spread? randomNextFloat() : 1)
    const a = randomNextFloat() * 6.283
    const ad = randomNextFloat() * r * .2 - w*.1
    acc[k] = (r+ad) * Math.sin(a)
    acc[k + 1] = 20
    acc[k + 2] = (r+ad) * Math.cos(a)
}

function tree (x, y, z, l, n, it, t, oldidx) {
    n += Math.cos(t * .25) * .2
  
    let r = randomNextFloat()
    const x1 = x + l * Math.sin(n) * r * 2
    const y1 = y - l * Math.cos(n)
    const z1 = z + l * Math.sin(n) * (1 - r) * 2
    const k = accidx * 4

    acc[k] = x1
    acc[k+1] = y1
    acc[k+2] = z1

    treel[k-4] = oldidx
    oldidx = accidx
    treel[k+2-4] = it++
    treel[k+1-4] = accidx++

    l *= .7

    if (it == 7 && bubblesGen == 1) {
        const k = bubbleidx*4
        bubbles[k] = x1
        bubbles[k+1] = y1
        bubbles[k+2] = z1
        bubbles[k+3] = .1 + r * .25
        bubbleidx++
    }

    if(it<7) tree(x1, y1, z1, l, n - 1, it, t, oldidx) 
    if(it<5) tree(x1, y1, z1, l, n + 1, it, t, oldidx)
    if(it<7) tree(x1, y1, z1, l, n + .4, it, t, oldidx)
  }

accidx = 1
tree(0, 100, 0, 200, 0, 0, 0, 0)
bubblesGen = 1
for (let i = 0; i < w; i++) generatePoint(i, true)

window.addEventListener('mousedown', _ => {
    document.body.requestFullscreen()

    setInterval(_ => {
        a.width = w
        a.height = h
    
        if (!state) {
            state = player.g() >= 1
            if (state) {
                audio.src = URL.createObjectURL(new Blob([player.w()], {type: "audio/wav"}))
                audio.play()
            }
        } else {
            let t = audio.currentTime

            let yangle = .5 * Math.sin(t * .1)
            let treeAlpha = 1
            let xoff = 0
            let yoff = h/4
            let maxCircle = 64
            titleAlpha = 0
            treeCircleAlpha = 1
            pointsAlpha = 1
            bubbleAlpha = 0
            zoff = h

            if (t < 13) {
                treeCircleAlpha = 0
                pointsAlpha = 0
                treeAlpha = easeOut(0,1,(t-3)/8)
                titleAlpha = easeOut(0,1,(t-5)/10)
            } else if(t < 27) {
                titleAlpha = easeOut(easeOut(0,1,(t-5)/10), 0, (t-21)/5) 
                xoff = easeOut(0, -w/4, (t-13)/8)
                zoff = easeOut(h, w, (t-13)/5)
                pointsAlpha = 0
                treeCircleAlpha = easeOut(0,1,(t - 13)/4)
            } else if(t < 40) {
                zoff = 500
                treeCircleAlpha = 0
                treeAlpha = 0
                maxCircle = 200
            } else if (t < 54) {
                zoff = easeOut(500, h, (t-40)/5)
                treeCircleAlpha = treeAlpha = easeOut(0, 1, (t-40)/10)
                maxCircle = easeOut(200, 64, (t-40)/5)
            } else if (t < 81) {
                zoff = easeOut(h, w, (t-54)/5)
                bubbleAlpha = 1
                yangle = .5 *  Math.sin(t*.2)
            } else if (t < 162) {
                bubbleAlpha = 1
                yangle = (t + accTime) * .05
                titleAlpha = accTime %4 == 0
            } else if (t < 177) {
                pointsAlpha = easeOut(1,0, (t-162)/3)
                titleAlpha = 1 - pointsAlpha
            } else {
                titleAlpha = treeAlpha = treeCircleAlpha = easeOut(1, 0, (t-177)/2)
                pointsAlpha = 0
            }
            c.globalCompositeOperation = 'lighter'
            c.fillStyle = E
            c.fillRect(0,0,w,h)

            const oldRs = randomSeed
            randomSeed = 0x12341234
            accidx = 1
            acc[0] = 0
            acc[1] = 0
            acc[2] = 0
            tree(0, 100, 0, 200, 0, 0, t, 0)
            bubblesGen = 0
            randomSeed = oldRs
            treeidx = accidx

            while(t - lastT > .005) {
                for (let i = 0; i < w; i++) {
                    const k = (i + treeidx)*4
                    acc[k  ] -= acc[k]*.002
                    acc[k+2] -= acc[k+2]*.002

                    if (acc[k] * acc[k] < 2) generatePoint(i)
                }

                for (let i = 0; i < bubbleidx; i++) bubbles[i*4+1] -= bubbles[i*4+3]

                if (bubbles[1] < -500) {
                    bubblesGen = 1
                    bubbleidx = 0
                }

                if (t > 80 && accTimeT-- == 0) {
                    accTime += 9
                    accTimeT = 290
                }
                lastT += .005
            }

            accidx = treeidx + w
            let pointsidx = accidx

            for (let i = 0; i < bubbleidx; i++) {
                const k = accidx*4
                acc[k] = bubbles[i*4]
                acc[k+1] = bubbles[i*4+1]
                acc[k+2] = bubbles[i*4+2]
                accidx++
            }
            
            const say = Math.sin(yangle)
            const cay = Math.cos(yangle)

            for(let i = 0; i < accidx; i++) {
                const k = i * 4
                pt2[k    ] = acc[k    ]
                pt2[k + 1] = acc[k + 1] - acc[k + 2] * .5
                pt2[k + 2] = acc[k + 1] * .5 + acc[k + 2]

                pt[k    ] = pt2[k    ] * cay + pt2[k + 2] * say
                pt[k + 1] = pt2[k + 1]
                const z = -pt2[k    ] * say + pt2[k + 2] * cay + zoff
            
                pt[k] = .8*w * pt[k] / z + w/2 + xoff
                pt[k+1] = .8*w * pt[k+1] / z + h/2 + yoff
                
                pt[k+3]= easeOut(maxCircle, 4, (z + w*2)/(w*4)) 
                pt[k+2] = z
            }

            let min = 0

            c.strokeStyle = '#e00'
            c.globalAlpha = treeAlpha
            for (let i = 0; i < treeidx; i++) {
                const f = 1-(treel[i*4+2]/7)
                c.lineWidth = easeOut(1, 32, t/10) * f**2+.2
                let i0 = treel[i*4]*4
                let i1 = treel[i*4+1]*4
                c.beginPath()
                c.moveTo(pt[i0], pt[i0+1])
                c.lineTo(pt[i1], pt[i1+1])
                c.stroke()
            }
            
            c.strokeStyle = c.fillStyle = '#fff'

            const coords = [treeidx, pointsidx, accidx]
            const alphas = [treeCircleAlpha, pointsAlpha, bubbleAlpha]
            for (let j = 0; j < 3; j++) {
                let max = coords[j]
                c.globalAlpha = alphas[j] * (j == 2 ? 1-(bubbles[5]/-500) : 1)

                for (let i = min; i < max; i++) {
                    if (pt[i*4+2] < 0) continue
                    c.beginPath()
                    c.arc(pt[i*4], pt[i*4+1], pt[i*4+3], 0, 6.283)
                    if (j < 2) c.fill()
                    else c.stroke()
                }
                min = max
            }

            c.globalAlpha = titleAlpha
            c.lineWidth = 8
            c.font = '200' + FN
            c.fillText('r173', w/2, h/2)
            c.font = '100' + FN
            c.textAlign = 'end'
            c.fillText('.bp.smash!.fuzzion.', w, h/2+100)
            c.beginPath()
            c.moveTo(w/2, h/2)
            c.lineTo(w, h/2)
            c.stroke()

            c.save()
            c.globalAlpha = .6
            let blur = 8
            while(blur >= 2) {
                c.filter = 'blur('+blur+'px)'
                c.drawImage(a, 0, 0)
                blur /= 2
            }
            c.restore()
        }
    })
})