import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: effect
    name: "blocker"
    enabled: syncRootOn(effect.name, effectName)

    Blit { textureRT: "current" }
    Shader { file: "blocker" }
    Texture { textureUnit: 0; textureRT: "current" }
    DrawVB {
        type: "quad"
        depthTest: false; depthWrite: false
        blendMode: "off"
        drawBuffers: 1
        ShaderParam { paramName: "pixelSize"; paramValue: sync(effect.name+".pixelSize") }
        ShaderParam { paramName: "moveAmp"; paramValueVec4: syncFFT(effect.name+".moveAmp")*sync(effect.name+".moveAmp.x")+","+syncFFT(effect.name+".moveAmp")*sync(effect.name+".moveAmp.y") }
        ShaderParam { paramName: "moveFreq"; paramValueVec4: sync(effect.name+".moveFreq.x")+","+sync(effect.name+".moveFreq.y") }
        ShaderParam { paramName: "movePhase"; paramValueVec4: syncFFT(effect.name+".movePhase")*sync(effect.name+".movePhase.x")+","+syncFFT(effect.name+".movePhase")*sync(effect.name+".movePhase.y") }
        ShaderParam { paramName: "moveRand"; paramValue: sync(effect.name+".moveRand") }

       // ShaderParam { paramName: "g_prevAmount"; paramValueVec4: sync(effect.name+".prevAmount.r")+","+sync(effect.name+".prevAmount.g")+","+sync(effect.name+".prevAmount.b")+","+sync(effect.name+".prevAmount") }
       // ShaderParam { paramName: "g_prevPow"; paramValueVec4: sync(effect.name+".prevPow.r")+","+sync(effect.name+".prevPow.g")+","+sync(effect.name+".prevPow.b")+","+sync(effect.name+".prevPow") }
       // ShaderParam { paramName: "flip"; paramValue: sync(effect.name+".flip") }
       // ShaderParam { paramName: "centerScale"; paramValueVec4: effect.center.x+","+effect.center.y+","+effect.sca.x+","+effect.sca.y }
    }
}
