import QtQuick 2.3
import AdaptDemoSystem 1.0

GroupBase {
  id: effect
  name: "breakin"
  effectName: "BreakIn"
  property bool enabledIn: true
  enabled: syncRootOn(effect.name, effectName) & enabledIn;

  property var syncIn: undefined
  property var syncFFTIn: undefined
  property var depthTestIn: undefined
  property var depthWriteIn: undefined
  property bool setShader: true
  property var fixedTimeStepIn: undefined


  property BreakInImpl impl
  Component {
    id: ec
    BreakInImpl {}
  }
  property bool autoCenter: false
  property bool autoScale: false
  property bool drawOnly: false


  property bool effectExists: false
  onEnabledChanged: {
    if (!enabled && effectExists) {
      effectExists = false;
      impl.destroy(0);
      //log("BreakIn removed:"+effect.name)
      impl = undefined;
    }
  }

  Connections {
    target: demo
    onFrameRendered: {
      if (effect.enabled && !effectExists) {
        effectExists = true;
//        impl = ec.createObject(effect,
//                               { name: effect.name,
//                                 effectName: effect.effectName,
//                                 autoCenter: effect.autoCenter,
//                                 autoScale: effect.autoScale,
//                                 drawOnly: effect.drawOnly
//                               });
        var effectSettings = {
          name: effect.name,
          effectName: effect.effectName,
          reDrawGroups: effect.reDrawGroups,
          setShader: effect.setShader,
          autoCenter: effect.autoCenter,
          autoScale: effect.autoScale,
          drawOnly: effect.drawOnly
          // meshParams: effect.meshParams
        };
        if (syncIn !== undefined) {
          effectSettings.syncIn = effect.syncIn;
        }
        if (syncFFTIn !== undefined) {
          effectSettings.syncFFTIn = effect.syncFFTIn;
        }
        if (depthTestIn !== undefined) {
          effectSettings.depthTestIn = effect.depthTestIn;
        }
        if (depthWriteIn !== undefined) {
          effectSettings.depthWriteIn = effect.depthWriteIn;
        }
        if (fixedTimeStepIn !== undefined) {
          effectSettings.fixedTimeStepIn = effect.fixedTimeStepIn
        }
        //    log("created BreakIn:"+effect.name)
        effect.impl = ec.createObject(effect, effectSettings);

      }
    }
  }
}
