import QtQuick 2.3
import AdaptDemoSystem 1.0

Effect {
  id: effect
  name: "lighter"
  effectName: "Lighter"
  enabled: syncRootOn(effect.name, effectName);

  Blit { textureRT: "current" }

  property real lightPosX: s("pos.x", 0.0)
  property real lightPosY: s("pos.y", 0.0)
  property real lightPosZ: s("pos.z", 0.0)

  // volumetric shadows from pardex's
  Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexTransmittance" } // read

  // main view RT's
  Texture { textureUnit: 0; textureRT: "current" }
  Texture { textureUnit: 1; textureRT: "mainDepth" }
  Texture { textureUnit: 2; textureRT: "depth" } // this actually contains normals ..x..

  // light view RT's
  Texture { textureUnit: 3; textureRT: "view"+effect.name+"_depth" }

  TextureSel { id: projectorTex; textureUnit: 4; nameOverride: effect.name+".projector.texInd" }

  Texture { textureUnit: 5; textureRT: "pardexMask" }

  property int transmitGridBD: skene.pardexTransmitRes !== undefined ?  skene.pardexTransmitRes : 16

  Shader { file: "lighter" }

  DrawVB {
    type: "quad"
    depthTest: false; depthWrite: false
    blendMode: "off"
    drawBuffers: 1
    secondView: "view"+effect.name
    secondView2: "lightPardexView"

    ShaderParam { paramName: "pos"; paramValueVec4: v(lightPosX, lightPosY, lightPosZ) }
    ShaderParam { paramName: "color"; paramValueVec4: v(s("color.r", 1.0), s("color.g", 1.0), s("color.b", 1.0)) }
    ShaderParam { paramName: "amp"; paramValue: s("mag.amp", 1.0) }
    ShaderParam { paramName: "_exp"; paramValue: s("mag.exp", 1.0) }
    ShaderParam { paramName: "distAmp"; paramValue: s("mag.distAmp", 1.0) }
    ShaderParam { paramName: "distExp"; paramValue: s("mag.distExp", 1.0) }
    ShaderParam { paramName: "ambient"; paramValue: s("mag.ambient", 1.0) }

    ShaderParam { paramName: "projectorAmp"; paramValue: s("projector.amp", 0.0) }
    ShaderParam { paramName: "projectorUvScale"; paramValue: s("projector.uvScale", 1.0) }

    ShaderParam { paramName: "shadowZOfs"; paramValue: sync("pardex.shadow.z.ofs") }
    ShaderParam { paramName: "shadowZScale"; paramValue: sync("pardex.shadow.z.scale") }
    ShaderParam { paramName: "baseDim"; paramValue: transmitGridBD }
    ShaderParam { paramName: "transmitEnabled"; paramValue: (sync("pardex.shadow.ON")>0.5 && sync("pardex.ON")>0.5) ? 1.0 : 0.0 }

    ShaderParam { paramName: "transmitPow"; paramValue: s("pardex.shadow.pow", 2.0) }
  }

  Shader { file: "flatShade" }
  DrawMesh {
    file: meshSel(effect.name+".mesh");
    enabled: true; smoothNormals: true; normalSmoothAngle: 80;
    blendMode: "off"
    drawBuffers: 1
    depthTest: true; depthWrite: true;
    Pos { x: lightPosX; y: lightPosY; z: lightPosZ }
    Sca { s: sync(effect.name+".mesh.scale"); x: 1.0; y: 1.0; z: 1.0 }
  }

}
