import QtQuick 2.3
import AdaptDemoSystem 1.0

GroupBase {
  id: effect
  name: "partiklos"
  effectName: "Partiklos"
  property bool enabledIn: true
  enabled: syncRootOn(effect.name, effectName) & enabledIn;

  property PartiklosImpl impl
  Component {
    id: ec
    PartiklosImpl {}
  }

  property bool effectExists: false
  onEnabledChanged: {
    if (!enabled && effectExists) {
      effectExists = false;
      impl.destroy(0);
      impl = undefined;
    }
  }
  Connections {
    target: demo
    onFrameRendered: {
      if (effect.enabled && !effectExists) {
        effectExists = true;
        impl = ec.createObject(effect, { name: effect.name } );
      }
    }
  }

}
