import QtQuick 2.3
import AdaptDemoSystem 1.0

import "../."

Group {
    id: texSel
    name: "texSel"


    function getEffectNameFromParent() {
        if (parent.effectName) {
            return parent.effectName;
        }
        if (parent.parent.effectName) {
            return parent.parent.effectName;
        }
        if (parent.parent.parent.effectName) {
            return parent.parent.parent.effectName;
        }
        if (parent.parent.parent.parent.effectName) {
            return parent.parent.parent.parent.effectName;
        }
        return effectName;

    }

    effectName: getEffectNameFromParent()

    TextureList {
        id: texList
    }

    property alias textureUnit: tex0.textureUnit
    property alias file: tex0.file

    property var selPresets: undefined

    property string nameOverride: ""

    property int texIndOverride: -1

    property int texCount0: texList.texList0.length
    property int texCount1: texList.texList1.length
    property int texCount2: texList.texList2.length
    property int texCount3: texList.texList3.length
    property int texCount4: texList.texList4.length
    property int texCount5: texList.texList5.length
    property string texPrefix: "../../images/"
    property string syncPostfix: ""

    property alias textureWrap: tex0.textureWrap

    property alias texInd: tex0.texInd

    property alias texWidth: tex0.texWidth
    property alias texHeight: tex0.texHeight

    property bool bTextureFromFile: true

    TextureImage {
        id: tex0

        effectName: texSel.effectName
        textureUnit: 0
        property int texInd: {
            if (texIndOverride >= 0) {
                return texIndOverride;
            }

            if (nameOverride === "") {
                if (selPresets !== undefined) {
                    return name!=="texSel" ? selPresets.get("texInd"+textureUnit+syncPostfix) : 0
                } else {
                    return name!=="texSel" ? sync(texSel.name+".texInd"+textureUnit+syncPostfix) : 0
                }
            } else {
                if (selPresets !== undefined) {
                    return selPresets.get(nameOverride);
                } else {
                    return sync(nameOverride);
                }
            }
        }

        property string texName: getTexFile(texInd)

        file: bTextureFromFile ? texPrefix+texName : texName
        textureRT: !bTextureFromFile ? texName : ""
    }


	function getTexFile(i) {
		var res = getTexFileInternal(i);
		if (res === "") {
			res = "bokeh_housus.png";
		}
		return res;
	}

    function getTexFileInternal(i) {
        var def = "";
        bTextureFromFile = true;
        if (i<0) return def;
        if (i<1000) {
            return i < texList.texList0.length ? texList.texList0[i] : texList.texList0[0];
        } else if (i<2000) {
            i-=1000;
            bTextureFromFile = false;
            return i < texList.texList1.length ? texList.texList1[i] : texList.texList1[0];
        } else if (i<3000) {
            i-=2000;
            return i < texList.texList2.length ? texList.texList2[i] : texList.texList2[0];
        } else if (i<4000) {
            i-=3000;
            return i < texList.texList3.length ? texList.texList3[i] : texList.texList3[0];
        } else if (i<5000) {
            i-=4000;
            return i < texList.texList4.length ? texList.texList4[i] : texList.texList4[0];
        } else if (i<6000) {
            i-=5000;
            return i < texList.texList5.length ? texList.texList5[i] : texList.texList5[0];
        }
        return def;
    }


}

