#version 430


in vec2 uv;

layout(location = 0) out vec4 frag;

uniform float g_time;

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}


layout(binding=0) uniform sampler2D texA;
layout(binding=1) uniform sampler2D texB;
layout(binding=2) uniform sampler2D texMask;

uniform float g_currentAmount = 1.0;
uniform float g_prevAmount = 1.0;

uniform float g_darkenAmp = 0.0;
uniform float g_darkenPow = 1.0;

uniform float effectWidth = 1280.0;
uniform float effectHeight = 720.0;

uniform float g_windowWidth = 1280.0;
uniform float g_windowHeight = 720.0;

void main() {


    vec4 screenA = texelFetch(texA, ivec2(gl_FragCoord.xy), 0);
    vec4 screenB = texelFetch(texB, ivec2(gl_FragCoord.xy), 0);
    vec4 mask = texelFetch(texMask, ivec2(gl_FragCoord.xy), 0);

    float alf = mask.r;

    float d = dot(screenB.xyz, vec3(0.2126, 0.7152, 0.0722));
    alf = clamp(mask.r*(d+0.50), 0.0, 1.0);

    frag = (1.0-alf)*screenA+alf*screenB;
    //frag = (1.0-alf)*screenA+screenB;
    //frag = screenB;
}
